// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetJobRunInput struct {
	_ struct{} `type:"structure"`

	// Name of the job definition being run.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// True if a list of predecessor runs should be returned.
	PredecessorsIncluded *bool `type:"boolean"`

	// The ID of the job run.
	//
	// RunId is a required field
	RunId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetJobRunInput"}

	if s.JobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if s.RunId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RunId"))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The requested job-run metadata.
	JobRun *JobRun `type:"structure"`
}

// String returns the string representation
func (s GetJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetJobRun = "GetJobRun"

// GetJobRunRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves the metadata for a given job run.
//
//    // Example sending a request using GetJobRunRequest.
//    req := client.GetJobRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun
func (c *Client) GetJobRunRequest(input *GetJobRunInput) GetJobRunRequest {
	op := &aws.Operation{
		Name:       opGetJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobRunInput{}
	}

	req := c.newRequest(op, input, &GetJobRunOutput{})

	return GetJobRunRequest{Request: req, Input: input, Copy: c.GetJobRunRequest}
}

// GetJobRunRequest is the request type for the
// GetJobRun API operation.
type GetJobRunRequest struct {
	*aws.Request
	Input *GetJobRunInput
	Copy  func(*GetJobRunInput) GetJobRunRequest
}

// Send marshals and sends the GetJobRun API request.
func (r GetJobRunRequest) Send(ctx context.Context) (*GetJobRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetJobRunResponse{
		GetJobRunOutput: r.Request.Data.(*GetJobRunOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetJobRunResponse is the response type for the
// GetJobRun API operation.
type GetJobRunResponse struct {
	*GetJobRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetJobRun request.
func (r *GetJobRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
