// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetJobRunsInput struct {
	_ struct{} `type:"structure"`

	// The name of the job definition for which to retrieve all job runs.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// The maximum size of the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetJobRunsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobRunsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetJobRunsInput"}

	if s.JobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetJobRunsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job-run metadata objects.
	JobRuns []JobRun `type:"list"`

	// A continuation token, if not all requested job runs have been returned.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetJobRunsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetJobRuns = "GetJobRuns"

// GetJobRunsRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves metadata for all runs of a given job definition.
//
//    // Example sending a request using GetJobRunsRequest.
//    req := client.GetJobRunsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns
func (c *Client) GetJobRunsRequest(input *GetJobRunsInput) GetJobRunsRequest {
	op := &aws.Operation{
		Name:       opGetJobRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetJobRunsInput{}
	}

	req := c.newRequest(op, input, &GetJobRunsOutput{})

	return GetJobRunsRequest{Request: req, Input: input, Copy: c.GetJobRunsRequest}
}

// GetJobRunsRequest is the request type for the
// GetJobRuns API operation.
type GetJobRunsRequest struct {
	*aws.Request
	Input *GetJobRunsInput
	Copy  func(*GetJobRunsInput) GetJobRunsRequest
}

// Send marshals and sends the GetJobRuns API request.
func (r GetJobRunsRequest) Send(ctx context.Context) (*GetJobRunsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetJobRunsResponse{
		GetJobRunsOutput: r.Request.Data.(*GetJobRunsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetJobRunsRequestPaginator returns a paginator for GetJobRuns.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetJobRunsRequest(input)
//   p := glue.NewGetJobRunsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetJobRunsPaginator(req GetJobRunsRequest) GetJobRunsPaginator {
	return GetJobRunsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetJobRunsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetJobRunsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetJobRunsPaginator struct {
	aws.Pager
}

func (p *GetJobRunsPaginator) CurrentPage() *GetJobRunsOutput {
	return p.Pager.CurrentPage().(*GetJobRunsOutput)
}

// GetJobRunsResponse is the response type for the
// GetJobRuns API operation.
type GetJobRunsResponse struct {
	*GetJobRunsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetJobRuns request.
func (r *GetJobRunsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
