// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTableVersionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is provided,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The maximum number of table versions to return in one response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call.
	NextToken *string `type:"string"`

	// The name of the table. For Hive compatibility, this name is entirely lowercase.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTableVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTableVersionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTableVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if the list of available versions does not include
	// the last one.
	NextToken *string `type:"string"`

	// A list of strings identifying available versions of the specified table.
	TableVersions []TableVersion `type:"list"`
}

// String returns the string representation
func (s GetTableVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTableVersions = "GetTableVersions"

// GetTableVersionsRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves a list of strings that identify available versions of a specified
// table.
//
//    // Example sending a request using GetTableVersionsRequest.
//    req := client.GetTableVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions
func (c *Client) GetTableVersionsRequest(input *GetTableVersionsInput) GetTableVersionsRequest {
	op := &aws.Operation{
		Name:       opGetTableVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTableVersionsInput{}
	}

	req := c.newRequest(op, input, &GetTableVersionsOutput{})

	return GetTableVersionsRequest{Request: req, Input: input, Copy: c.GetTableVersionsRequest}
}

// GetTableVersionsRequest is the request type for the
// GetTableVersions API operation.
type GetTableVersionsRequest struct {
	*aws.Request
	Input *GetTableVersionsInput
	Copy  func(*GetTableVersionsInput) GetTableVersionsRequest
}

// Send marshals and sends the GetTableVersions API request.
func (r GetTableVersionsRequest) Send(ctx context.Context) (*GetTableVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTableVersionsResponse{
		GetTableVersionsOutput: r.Request.Data.(*GetTableVersionsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetTableVersionsRequestPaginator returns a paginator for GetTableVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetTableVersionsRequest(input)
//   p := glue.NewGetTableVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetTableVersionsPaginator(req GetTableVersionsRequest) GetTableVersionsPaginator {
	return GetTableVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetTableVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetTableVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetTableVersionsPaginator struct {
	aws.Pager
}

func (p *GetTableVersionsPaginator) CurrentPage() *GetTableVersionsOutput {
	return p.Pager.CurrentPage().(*GetTableVersionsOutput)
}

// GetTableVersionsResponse is the response type for the
// GetTableVersions API operation.
type GetTableVersionsResponse struct {
	*GetTableVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTableVersions request.
func (r *GetTableVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
