// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTriggerInput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTriggerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTriggerInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The requested trigger definition.
	Trigger *Trigger `type:"structure"`
}

// String returns the string representation
func (s GetTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTrigger = "GetTrigger"

// GetTriggerRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves the definition of a trigger.
//
//    // Example sending a request using GetTriggerRequest.
//    req := client.GetTriggerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger
func (c *Client) GetTriggerRequest(input *GetTriggerInput) GetTriggerRequest {
	op := &aws.Operation{
		Name:       opGetTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTriggerInput{}
	}

	req := c.newRequest(op, input, &GetTriggerOutput{})

	return GetTriggerRequest{Request: req, Input: input, Copy: c.GetTriggerRequest}
}

// GetTriggerRequest is the request type for the
// GetTrigger API operation.
type GetTriggerRequest struct {
	*aws.Request
	Input *GetTriggerInput
	Copy  func(*GetTriggerInput) GetTriggerRequest
}

// Send marshals and sends the GetTrigger API request.
func (r GetTriggerRequest) Send(ctx context.Context) (*GetTriggerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTriggerResponse{
		GetTriggerOutput: r.Request.Data.(*GetTriggerOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetTriggerResponse is the response type for the
// GetTrigger API operation.
type GetTriggerResponse struct {
	*GetTriggerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTrigger request.
func (r *GetTriggerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
