// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopWorkflowRunInput struct {
	_ struct{} `type:"structure"`

	// The name of the workflow to stop.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The ID of the workflow run to stop.
	//
	// RunId is a required field
	RunId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopWorkflowRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkflowRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopWorkflowRunInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RunId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RunId"))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopWorkflowRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopWorkflowRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopWorkflowRun = "StopWorkflowRun"

// StopWorkflowRunRequest returns a request value for making API operation for
// AWS Glue.
//
// Stops the execution of the specified workflow run.
//
//    // Example sending a request using StopWorkflowRunRequest.
//    req := client.StopWorkflowRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopWorkflowRun
func (c *Client) StopWorkflowRunRequest(input *StopWorkflowRunInput) StopWorkflowRunRequest {
	op := &aws.Operation{
		Name:       opStopWorkflowRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkflowRunInput{}
	}

	req := c.newRequest(op, input, &StopWorkflowRunOutput{})

	return StopWorkflowRunRequest{Request: req, Input: input, Copy: c.StopWorkflowRunRequest}
}

// StopWorkflowRunRequest is the request type for the
// StopWorkflowRun API operation.
type StopWorkflowRunRequest struct {
	*aws.Request
	Input *StopWorkflowRunInput
	Copy  func(*StopWorkflowRunInput) StopWorkflowRunRequest
}

// Send marshals and sends the StopWorkflowRun API request.
func (r StopWorkflowRunRequest) Send(ctx context.Context) (*StopWorkflowRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopWorkflowRunResponse{
		StopWorkflowRunOutput: r.Request.Data.(*StopWorkflowRunOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopWorkflowRunResponse is the response type for the
// StopWorkflowRun API operation.
type StopWorkflowRunResponse struct {
	*StopWorkflowRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopWorkflowRun request.
func (r *StopWorkflowRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
