// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateColumnStatisticsForPartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partitions in question reside. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A list of the column statistics.
	//
	// ColumnStatisticsList is a required field
	ColumnStatisticsList []ColumnStatistics `type:"list" required:"true"`

	// The name of the catalog database where the partitions reside.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of partition values identifying the partition.
	//
	// PartitionValues is a required field
	PartitionValues []string `type:"list" required:"true"`

	// The name of the partitions' table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateColumnStatisticsForPartitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateColumnStatisticsForPartitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateColumnStatisticsForPartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.ColumnStatisticsList == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnStatisticsList"))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.PartitionValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("PartitionValues"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}
	if s.ColumnStatisticsList != nil {
		for i, v := range s.ColumnStatisticsList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnStatisticsList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateColumnStatisticsForPartitionOutput struct {
	_ struct{} `type:"structure"`

	// Error occurred during updating column statistics data.
	Errors []ColumnStatisticsError `type:"list"`
}

// String returns the string representation
func (s UpdateColumnStatisticsForPartitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateColumnStatisticsForPartition = "UpdateColumnStatisticsForPartition"

// UpdateColumnStatisticsForPartitionRequest returns a request value for making API operation for
// AWS Glue.
//
// Creates or updates partition statistics of columns.
//
//    // Example sending a request using UpdateColumnStatisticsForPartitionRequest.
//    req := client.UpdateColumnStatisticsForPartitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForPartition
func (c *Client) UpdateColumnStatisticsForPartitionRequest(input *UpdateColumnStatisticsForPartitionInput) UpdateColumnStatisticsForPartitionRequest {
	op := &aws.Operation{
		Name:       opUpdateColumnStatisticsForPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateColumnStatisticsForPartitionInput{}
	}

	req := c.newRequest(op, input, &UpdateColumnStatisticsForPartitionOutput{})

	return UpdateColumnStatisticsForPartitionRequest{Request: req, Input: input, Copy: c.UpdateColumnStatisticsForPartitionRequest}
}

// UpdateColumnStatisticsForPartitionRequest is the request type for the
// UpdateColumnStatisticsForPartition API operation.
type UpdateColumnStatisticsForPartitionRequest struct {
	*aws.Request
	Input *UpdateColumnStatisticsForPartitionInput
	Copy  func(*UpdateColumnStatisticsForPartitionInput) UpdateColumnStatisticsForPartitionRequest
}

// Send marshals and sends the UpdateColumnStatisticsForPartition API request.
func (r UpdateColumnStatisticsForPartitionRequest) Send(ctx context.Context) (*UpdateColumnStatisticsForPartitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateColumnStatisticsForPartitionResponse{
		UpdateColumnStatisticsForPartitionOutput: r.Request.Data.(*UpdateColumnStatisticsForPartitionOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateColumnStatisticsForPartitionResponse is the response type for the
// UpdateColumnStatisticsForPartition API operation.
type UpdateColumnStatisticsForPartitionResponse struct {
	*UpdateColumnStatisticsForPartitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateColumnStatisticsForPartition request.
func (r *UpdateColumnStatisticsForPartitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
