// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateColumnStatisticsForTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partitions in question reside. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A list of the column statistics.
	//
	// ColumnStatisticsList is a required field
	ColumnStatisticsList []ColumnStatistics `type:"list" required:"true"`

	// The name of the catalog database where the partitions reside.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the partitions' table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateColumnStatisticsForTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateColumnStatisticsForTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateColumnStatisticsForTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.ColumnStatisticsList == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnStatisticsList"))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}
	if s.ColumnStatisticsList != nil {
		for i, v := range s.ColumnStatisticsList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnStatisticsList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateColumnStatisticsForTableOutput struct {
	_ struct{} `type:"structure"`

	// List of ColumnStatisticsErrors.
	Errors []ColumnStatisticsError `type:"list"`
}

// String returns the string representation
func (s UpdateColumnStatisticsForTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateColumnStatisticsForTable = "UpdateColumnStatisticsForTable"

// UpdateColumnStatisticsForTableRequest returns a request value for making API operation for
// AWS Glue.
//
// Creates or updates table statistics of columns.
//
//    // Example sending a request using UpdateColumnStatisticsForTableRequest.
//    req := client.UpdateColumnStatisticsForTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForTable
func (c *Client) UpdateColumnStatisticsForTableRequest(input *UpdateColumnStatisticsForTableInput) UpdateColumnStatisticsForTableRequest {
	op := &aws.Operation{
		Name:       opUpdateColumnStatisticsForTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateColumnStatisticsForTableInput{}
	}

	req := c.newRequest(op, input, &UpdateColumnStatisticsForTableOutput{})

	return UpdateColumnStatisticsForTableRequest{Request: req, Input: input, Copy: c.UpdateColumnStatisticsForTableRequest}
}

// UpdateColumnStatisticsForTableRequest is the request type for the
// UpdateColumnStatisticsForTable API operation.
type UpdateColumnStatisticsForTableRequest struct {
	*aws.Request
	Input *UpdateColumnStatisticsForTableInput
	Copy  func(*UpdateColumnStatisticsForTableInput) UpdateColumnStatisticsForTableRequest
}

// Send marshals and sends the UpdateColumnStatisticsForTable API request.
func (r UpdateColumnStatisticsForTableRequest) Send(ctx context.Context) (*UpdateColumnStatisticsForTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateColumnStatisticsForTableResponse{
		UpdateColumnStatisticsForTableOutput: r.Request.Data.(*UpdateColumnStatisticsForTableOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateColumnStatisticsForTableResponse is the response type for the
// UpdateColumnStatisticsForTable API operation.
type UpdateColumnStatisticsForTableResponse struct {
	*UpdateColumnStatisticsForTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateColumnStatisticsForTable request.
func (r *UpdateColumnStatisticsForTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
