// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AssociateServiceRoleToAccountInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the service role you wish to associate with your account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateServiceRoleToAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateServiceRoleToAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateServiceRoleToAccountInput"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateServiceRoleToAccountInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AssociateServiceRoleToAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time when the service role was associated with the account.
	AssociatedAt *string `type:"string"`
}

// String returns the string representation
func (s AssociateServiceRoleToAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateServiceRoleToAccountOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociatedAt != nil {
		v := *s.AssociatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opAssociateServiceRoleToAccount = "AssociateServiceRoleToAccount"

// AssociateServiceRoleToAccountRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Associates a role with your account. AWS IoT Greengrass will use the role
// to access your Lambda functions and AWS IoT resources. This is necessary
// for deployments to succeed. The role must have at least minimum permissions
// in the policy ''AWSGreengrassResourceAccessRolePolicy''.
//
//    // Example sending a request using AssociateServiceRoleToAccountRequest.
//    req := client.AssociateServiceRoleToAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount
func (c *Client) AssociateServiceRoleToAccountRequest(input *AssociateServiceRoleToAccountInput) AssociateServiceRoleToAccountRequest {
	op := &aws.Operation{
		Name:       opAssociateServiceRoleToAccount,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &AssociateServiceRoleToAccountInput{}
	}

	req := c.newRequest(op, input, &AssociateServiceRoleToAccountOutput{})

	return AssociateServiceRoleToAccountRequest{Request: req, Input: input, Copy: c.AssociateServiceRoleToAccountRequest}
}

// AssociateServiceRoleToAccountRequest is the request type for the
// AssociateServiceRoleToAccount API operation.
type AssociateServiceRoleToAccountRequest struct {
	*aws.Request
	Input *AssociateServiceRoleToAccountInput
	Copy  func(*AssociateServiceRoleToAccountInput) AssociateServiceRoleToAccountRequest
}

// Send marshals and sends the AssociateServiceRoleToAccount API request.
func (r AssociateServiceRoleToAccountRequest) Send(ctx context.Context) (*AssociateServiceRoleToAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateServiceRoleToAccountResponse{
		AssociateServiceRoleToAccountOutput: r.Request.Data.(*AssociateServiceRoleToAccountOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateServiceRoleToAccountResponse is the response type for the
// AssociateServiceRoleToAccount API operation.
type AssociateServiceRoleToAccountResponse struct {
	*AssociateServiceRoleToAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateServiceRoleToAccount request.
func (r *AssociateServiceRoleToAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
