// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about a core definition version.
	InitialVersion *CoreDefinitionVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCoreDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCoreDefinitionInput"}
	if s.InitialVersion != nil {
		if err := s.InitialVersion.Validate(); err != nil {
			invalidParams.AddNested("InitialVersion", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCoreDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.InitialVersion != nil {
		v := s.InitialVersion

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InitialVersion", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.AmznClientToken != nil {
		v := *s.AmznClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amzn-Client-Token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCoreDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTimestamp != nil {
		v := *s.CreationTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedTimestamp != nil {
		v := *s.LastUpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LatestVersion != nil {
		v := *s.LatestVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LatestVersionArn != nil {
		v := *s.LatestVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateCoreDefinition = "CreateCoreDefinition"

// CreateCoreDefinitionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Creates a core definition. You may provide the initial version of the core
// definition now or use ''CreateCoreDefinitionVersion'' at a later time. Greengrass
// groups must each contain exactly one Greengrass core.
//
//    // Example sending a request using CreateCoreDefinitionRequest.
//    req := client.CreateCoreDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition
func (c *Client) CreateCoreDefinitionRequest(input *CreateCoreDefinitionInput) CreateCoreDefinitionRequest {
	op := &aws.Operation{
		Name:       opCreateCoreDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/cores",
	}

	if input == nil {
		input = &CreateCoreDefinitionInput{}
	}

	req := c.newRequest(op, input, &CreateCoreDefinitionOutput{})

	return CreateCoreDefinitionRequest{Request: req, Input: input, Copy: c.CreateCoreDefinitionRequest}
}

// CreateCoreDefinitionRequest is the request type for the
// CreateCoreDefinition API operation.
type CreateCoreDefinitionRequest struct {
	*aws.Request
	Input *CreateCoreDefinitionInput
	Copy  func(*CreateCoreDefinitionInput) CreateCoreDefinitionRequest
}

// Send marshals and sends the CreateCoreDefinition API request.
func (r CreateCoreDefinitionRequest) Send(ctx context.Context) (*CreateCoreDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCoreDefinitionResponse{
		CreateCoreDefinitionOutput: r.Request.Data.(*CreateCoreDefinitionOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCoreDefinitionResponse is the response type for the
// CreateCoreDefinition API operation.
type CreateCoreDefinitionResponse struct {
	*CreateCoreDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCoreDefinition request.
func (r *CreateCoreDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
