// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListResourceDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListResourceDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListResourceDefinitionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListResourceDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourceDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListResourceDefinitionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Definitions != nil {
		v := s.Definitions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Definitions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListResourceDefinitions = "ListResourceDefinitions"

// ListResourceDefinitionsRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Retrieves a list of resource definitions.
//
//    // Example sending a request using ListResourceDefinitionsRequest.
//    req := client.ListResourceDefinitionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions
func (c *Client) ListResourceDefinitionsRequest(input *ListResourceDefinitionsInput) ListResourceDefinitionsRequest {
	op := &aws.Operation{
		Name:       opListResourceDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources",
	}

	if input == nil {
		input = &ListResourceDefinitionsInput{}
	}

	req := c.newRequest(op, input, &ListResourceDefinitionsOutput{})

	return ListResourceDefinitionsRequest{Request: req, Input: input, Copy: c.ListResourceDefinitionsRequest}
}

// ListResourceDefinitionsRequest is the request type for the
// ListResourceDefinitions API operation.
type ListResourceDefinitionsRequest struct {
	*aws.Request
	Input *ListResourceDefinitionsInput
	Copy  func(*ListResourceDefinitionsInput) ListResourceDefinitionsRequest
}

// Send marshals and sends the ListResourceDefinitions API request.
func (r ListResourceDefinitionsRequest) Send(ctx context.Context) (*ListResourceDefinitionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourceDefinitionsResponse{
		ListResourceDefinitionsOutput: r.Request.Data.(*ListResourceDefinitionsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListResourceDefinitionsResponse is the response type for the
// ListResourceDefinitions API operation.
type ListResourceDefinitionsResponse struct {
	*ListResourceDefinitionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResourceDefinitions request.
func (r *ListResourceDefinitionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
