// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListSatellitesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of satellites returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Next token that can be supplied in the next call to get the next page of
	// satellites.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSatellitesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSatellitesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListSatellitesOutput struct {
	_ struct{} `type:"structure"`

	// Next token that can be supplied in the next call to get the next page of
	// satellites.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of satellites.
	Satellites []SatelliteListItem `locationName:"satellites" type:"list"`
}

// String returns the string representation
func (s ListSatellitesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSatellitesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Satellites != nil {
		v := s.Satellites

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "satellites", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListSatellites = "ListSatellites"

// ListSatellitesRequest returns a request value for making API operation for
// AWS Ground Station.
//
// Returns a list of satellites.
//
//    // Example sending a request using ListSatellitesRequest.
//    req := client.ListSatellitesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites
func (c *Client) ListSatellitesRequest(input *ListSatellitesInput) ListSatellitesRequest {
	op := &aws.Operation{
		Name:       opListSatellites,
		HTTPMethod: "GET",
		HTTPPath:   "/satellite",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSatellitesInput{}
	}

	req := c.newRequest(op, input, &ListSatellitesOutput{})

	return ListSatellitesRequest{Request: req, Input: input, Copy: c.ListSatellitesRequest}
}

// ListSatellitesRequest is the request type for the
// ListSatellites API operation.
type ListSatellitesRequest struct {
	*aws.Request
	Input *ListSatellitesInput
	Copy  func(*ListSatellitesInput) ListSatellitesRequest
}

// Send marshals and sends the ListSatellites API request.
func (r ListSatellitesRequest) Send(ctx context.Context) (*ListSatellitesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSatellitesResponse{
		ListSatellitesOutput: r.Request.Data.(*ListSatellitesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSatellitesRequestPaginator returns a paginator for ListSatellites.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSatellitesRequest(input)
//   p := groundstation.NewListSatellitesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSatellitesPaginator(req ListSatellitesRequest) ListSatellitesPaginator {
	return ListSatellitesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSatellitesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSatellitesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSatellitesPaginator struct {
	aws.Pager
}

func (p *ListSatellitesPaginator) CurrentPage() *ListSatellitesOutput {
	return p.Pager.CurrentPage().(*ListSatellitesOutput)
}

// ListSatellitesResponse is the response type for the
// ListSatellites API operation.
type ListSatellitesResponse struct {
	*ListSatellitesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSatellites request.
func (r *ListSatellitesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
