// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Details about an antenna demod decode Config used in a contact.
type AntennaDemodDecodeDetails struct {
	_ struct{} `type:"structure"`

	// Name of an antenna demod decode output node used in a contact.
	OutputNode *string `locationName:"outputNode" type:"string"`
}

// String returns the string representation
func (s AntennaDemodDecodeDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AntennaDemodDecodeDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.OutputNode != nil {
		v := *s.OutputNode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outputNode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about how AWS Ground Station should configure an antenna for
// downlink during a contact.
type AntennaDownlinkConfig struct {
	_ struct{} `type:"structure"`

	// Object that describes a spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *SpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s AntennaDownlinkConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaDownlinkConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AntennaDownlinkConfig"}

	if s.SpectrumConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpectrumConfig"))
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AntennaDownlinkConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.SpectrumConfig != nil {
		v := s.SpectrumConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spectrumConfig", v, metadata)
	}
	return nil
}

// Information about how AWS Ground Station should conﬁgure an antenna for
// downlink demod decode during a contact.
type AntennaDownlinkDemodDecodeConfig struct {
	_ struct{} `type:"structure"`

	// Information about the decode Config.
	//
	// DecodeConfig is a required field
	DecodeConfig *DecodeConfig `locationName:"decodeConfig" type:"structure" required:"true"`

	// Information about the demodulation Config.
	//
	// DemodulationConfig is a required field
	DemodulationConfig *DemodulationConfig `locationName:"demodulationConfig" type:"structure" required:"true"`

	// Information about the spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *SpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s AntennaDownlinkDemodDecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaDownlinkDemodDecodeConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AntennaDownlinkDemodDecodeConfig"}

	if s.DecodeConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("DecodeConfig"))
	}

	if s.DemodulationConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("DemodulationConfig"))
	}

	if s.SpectrumConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpectrumConfig"))
	}
	if s.DecodeConfig != nil {
		if err := s.DecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("DecodeConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.DemodulationConfig != nil {
		if err := s.DemodulationConfig.Validate(); err != nil {
			invalidParams.AddNested("DemodulationConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AntennaDownlinkDemodDecodeConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.DecodeConfig != nil {
		v := s.DecodeConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "decodeConfig", v, metadata)
	}
	if s.DemodulationConfig != nil {
		v := s.DemodulationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "demodulationConfig", v, metadata)
	}
	if s.SpectrumConfig != nil {
		v := s.SpectrumConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spectrumConfig", v, metadata)
	}
	return nil
}

// Information about the uplink Config of an antenna.
type AntennaUplinkConfig struct {
	_ struct{} `type:"structure"`

	// Information about the uplink spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *UplinkSpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`

	// EIRP of the target.
	//
	// TargetEirp is a required field
	TargetEirp *Eirp `locationName:"targetEirp" type:"structure" required:"true"`

	// Whether or not uplink transmit is disabled.
	TransmitDisabled *bool `locationName:"transmitDisabled" type:"boolean"`
}

// String returns the string representation
func (s AntennaUplinkConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaUplinkConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AntennaUplinkConfig"}

	if s.SpectrumConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpectrumConfig"))
	}

	if s.TargetEirp == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetEirp"))
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.TargetEirp != nil {
		if err := s.TargetEirp.Validate(); err != nil {
			invalidParams.AddNested("TargetEirp", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AntennaUplinkConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.SpectrumConfig != nil {
		v := s.SpectrumConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spectrumConfig", v, metadata)
	}
	if s.TargetEirp != nil {
		v := s.TargetEirp

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "targetEirp", v, metadata)
	}
	if s.TransmitDisabled != nil {
		v := *s.TransmitDisabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transmitDisabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Details for certain Config object types in a contact.
type ConfigDetails struct {
	_ struct{} `type:"structure"`

	// Details for antenna demod decode Config in a contact.
	AntennaDemodDecodeDetails *AntennaDemodDecodeDetails `locationName:"antennaDemodDecodeDetails" type:"structure"`

	// Information about the endpoint details.
	EndpointDetails *EndpointDetails `locationName:"endpointDetails" type:"structure"`
}

// String returns the string representation
func (s ConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfigDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AntennaDemodDecodeDetails != nil {
		v := s.AntennaDemodDecodeDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "antennaDemodDecodeDetails", v, metadata)
	}
	if s.EndpointDetails != nil {
		v := s.EndpointDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "endpointDetails", v, metadata)
	}
	return nil
}

// An item in a list of Config objects.
type ConfigListItem struct {
	_ struct{} `type:"structure"`

	// ARN of a Config.
	ConfigArn *string `locationName:"configArn" type:"string"`

	// UUID of a Config.
	ConfigId *string `locationName:"configId" type:"string"`

	// Type of a Config.
	ConfigType ConfigCapabilityType `locationName:"configType" type:"string" enum:"true"`

	// Name of a Config.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ConfigListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfigListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigArn != nil {
		v := *s.ConfigArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigId != nil {
		v := *s.ConfigId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConfigType) > 0 {
		v := s.ConfigType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Object containing the parameters of a Config.
//
// See the subtype definitions for what each type of Config contains.
type ConfigTypeData struct {
	_ struct{} `type:"structure"`

	// Information about how AWS Ground Station should configure an antenna for
	// downlink during a contact.
	AntennaDownlinkConfig *AntennaDownlinkConfig `locationName:"antennaDownlinkConfig" type:"structure"`

	// Information about how AWS Ground Station should conﬁgure an antenna for
	// downlink demod decode during a contact.
	AntennaDownlinkDemodDecodeConfig *AntennaDownlinkDemodDecodeConfig `locationName:"antennaDownlinkDemodDecodeConfig" type:"structure"`

	// Information about how AWS Ground Station should conﬁgure an antenna for
	// uplink during a contact.
	AntennaUplinkConfig *AntennaUplinkConfig `locationName:"antennaUplinkConfig" type:"structure"`

	// Information about the dataflow endpoint Config.
	DataflowEndpointConfig *DataflowEndpointConfig `locationName:"dataflowEndpointConfig" type:"structure"`

	// Object that determines whether tracking should be used during a contact executed
	// with this Config in the mission profile.
	TrackingConfig *TrackingConfig `locationName:"trackingConfig" type:"structure"`

	// Information about an uplink echo Config.
	//
	// Parameters from the AntennaUplinkConfig, corresponding to the specified AntennaUplinkConfigArn,
	// are used when this UplinkEchoConfig is used in a contact.
	UplinkEchoConfig *UplinkEchoConfig `locationName:"uplinkEchoConfig" type:"structure"`
}

// String returns the string representation
func (s ConfigTypeData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigTypeData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigTypeData"}
	if s.AntennaDownlinkConfig != nil {
		if err := s.AntennaDownlinkConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaDownlinkConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.AntennaDownlinkDemodDecodeConfig != nil {
		if err := s.AntennaDownlinkDemodDecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaDownlinkDemodDecodeConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.AntennaUplinkConfig != nil {
		if err := s.AntennaUplinkConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaUplinkConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.DataflowEndpointConfig != nil {
		if err := s.DataflowEndpointConfig.Validate(); err != nil {
			invalidParams.AddNested("DataflowEndpointConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.TrackingConfig != nil {
		if err := s.TrackingConfig.Validate(); err != nil {
			invalidParams.AddNested("TrackingConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.UplinkEchoConfig != nil {
		if err := s.UplinkEchoConfig.Validate(); err != nil {
			invalidParams.AddNested("UplinkEchoConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfigTypeData) MarshalFields(e protocol.FieldEncoder) error {
	if s.AntennaDownlinkConfig != nil {
		v := s.AntennaDownlinkConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "antennaDownlinkConfig", v, metadata)
	}
	if s.AntennaDownlinkDemodDecodeConfig != nil {
		v := s.AntennaDownlinkDemodDecodeConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "antennaDownlinkDemodDecodeConfig", v, metadata)
	}
	if s.AntennaUplinkConfig != nil {
		v := s.AntennaUplinkConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "antennaUplinkConfig", v, metadata)
	}
	if s.DataflowEndpointConfig != nil {
		v := s.DataflowEndpointConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dataflowEndpointConfig", v, metadata)
	}
	if s.TrackingConfig != nil {
		v := s.TrackingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "trackingConfig", v, metadata)
	}
	if s.UplinkEchoConfig != nil {
		v := s.UplinkEchoConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "uplinkEchoConfig", v, metadata)
	}
	return nil
}

// Data describing a contact.
type ContactData struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	ContactId *string `locationName:"contactId" type:"string"`

	// Status of a contact.
	ContactStatus ContactStatus `locationName:"contactStatus" type:"string" enum:"true"`

	// End time of a contact.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Error message of a contact.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Name of a ground station.
	GroundStation *string `locationName:"groundStation" type:"string"`

	// Maximum elevation angle of a contact.
	MaximumElevation *Elevation `locationName:"maximumElevation" type:"structure"`

	// ARN of a mission profile.
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	PostPassEndTime *time.Time `locationName:"postPassEndTime" type:"timestamp"`

	// Amount of time prior to contact start you’d like to receive a CloudWatch
	// event indicating an upcoming pass.
	PrePassStartTime *time.Time `locationName:"prePassStartTime" type:"timestamp"`

	// Region of a contact.
	Region *string `locationName:"region" type:"string"`

	// ARN of a satellite.
	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	// Start time of a contact.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Tags assigned to a contact.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ContactData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContactData) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ContactStatus) > 0 {
		v := s.ContactStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contactStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroundStation != nil {
		v := *s.GroundStation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groundStation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaximumElevation != nil {
		v := s.MaximumElevation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "maximumElevation", v, metadata)
	}
	if s.MissionProfileArn != nil {
		v := *s.MissionProfileArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "missionProfileArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PostPassEndTime != nil {
		v := *s.PostPassEndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "postPassEndTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PrePassStartTime != nil {
		v := *s.PrePassStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prePassStartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SatelliteArn != nil {
		v := *s.SatelliteArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "satelliteArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Information about a dataflow edge used in a contact.
type DataflowDetail struct {
	_ struct{} `type:"structure"`

	// Dataflow details for the destination side.
	Destination *Destination `locationName:"destination" type:"structure"`

	// Dataflow details for the source side.
	Source *Source `locationName:"source" type:"structure"`
}

// String returns the string representation
func (s DataflowDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataflowDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	if s.Source != nil {
		v := s.Source

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "source", v, metadata)
	}
	return nil
}

// Information about a dataflow endpoint.
type DataflowEndpoint struct {
	_ struct{} `type:"structure"`

	// Socket address of a dataflow endpoint.
	Address *SocketAddress `locationName:"address" type:"structure"`

	// Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.
	Mtu *int64 `locationName:"mtu" min:"1400" type:"integer"`

	// Name of a dataflow endpoint.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Status of a dataflow endpoint.
	Status EndpointStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DataflowEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataflowEndpoint) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataflowEndpoint"}
	if s.Mtu != nil && *s.Mtu < 1400 {
		invalidParams.Add(aws.NewErrParamMinValue("Mtu", 1400))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataflowEndpoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := s.Address

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "address", v, metadata)
	}
	if s.Mtu != nil {
		v := *s.Mtu

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mtu", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about the dataflow endpoint Config.
type DataflowEndpointConfig struct {
	_ struct{} `type:"structure"`

	// Name of a dataflow endpoint.
	//
	// DataflowEndpointName is a required field
	DataflowEndpointName *string `locationName:"dataflowEndpointName" type:"string" required:"true"`

	// Region of a dataflow endpoint.
	DataflowEndpointRegion *string `locationName:"dataflowEndpointRegion" type:"string"`
}

// String returns the string representation
func (s DataflowEndpointConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataflowEndpointConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataflowEndpointConfig"}

	if s.DataflowEndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataflowEndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataflowEndpointConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataflowEndpointName != nil {
		v := *s.DataflowEndpointName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataflowEndpointRegion != nil {
		v := *s.DataflowEndpointRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Item in a list of DataflowEndpoint groups.
type DataflowEndpointListItem struct {
	_ struct{} `type:"structure"`

	// ARN of a dataflow endpoint group.
	DataflowEndpointGroupArn *string `locationName:"dataflowEndpointGroupArn" type:"string"`

	// UUID of a dataflow endpoint group.
	DataflowEndpointGroupId *string `locationName:"dataflowEndpointGroupId" type:"string"`
}

// String returns the string representation
func (s DataflowEndpointListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataflowEndpointListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataflowEndpointGroupArn != nil {
		v := *s.DataflowEndpointGroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointGroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataflowEndpointGroupId != nil {
		v := *s.DataflowEndpointGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the decode Config.
type DecodeConfig struct {
	_ struct{} `type:"structure"`

	// Unvalidated JSON of a decode Config.
	//
	// UnvalidatedJSON is a required field
	UnvalidatedJSON *string `locationName:"unvalidatedJSON" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecodeConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DecodeConfig"}

	if s.UnvalidatedJSON == nil {
		invalidParams.Add(aws.NewErrParamRequired("UnvalidatedJSON"))
	}
	if s.UnvalidatedJSON != nil && len(*s.UnvalidatedJSON) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("UnvalidatedJSON", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DecodeConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.UnvalidatedJSON != nil {
		v := *s.UnvalidatedJSON

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unvalidatedJSON", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the demodulation Config.
type DemodulationConfig struct {
	_ struct{} `type:"structure"`

	// Unvalidated JSON of a demodulation Config.
	//
	// UnvalidatedJSON is a required field
	UnvalidatedJSON *string `locationName:"unvalidatedJSON" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DemodulationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DemodulationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DemodulationConfig"}

	if s.UnvalidatedJSON == nil {
		invalidParams.Add(aws.NewErrParamRequired("UnvalidatedJSON"))
	}
	if s.UnvalidatedJSON != nil && len(*s.UnvalidatedJSON) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("UnvalidatedJSON", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DemodulationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.UnvalidatedJSON != nil {
		v := *s.UnvalidatedJSON

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unvalidatedJSON", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Dataflow details for the destination side.
type Destination struct {
	_ struct{} `type:"structure"`

	// Additional details for a Config, if type is dataflow endpoint or antenna
	// demod decode.
	ConfigDetails *ConfigDetails `locationName:"configDetails" type:"structure"`

	// UUID of a Config.
	ConfigId *string `locationName:"configId" type:"string"`

	// Type of a Config.
	ConfigType ConfigCapabilityType `locationName:"configType" type:"string" enum:"true"`

	// Region of a dataflow destination.
	DataflowDestinationRegion *string `locationName:"dataflowDestinationRegion" type:"string"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigDetails != nil {
		v := s.ConfigDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "configDetails", v, metadata)
	}
	if s.ConfigId != nil {
		v := *s.ConfigId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConfigType) > 0 {
		v := s.ConfigType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DataflowDestinationRegion != nil {
		v := *s.DataflowDestinationRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowDestinationRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Object that represents EIRP.
type Eirp struct {
	_ struct{} `type:"structure"`

	// Units of an EIRP.
	//
	// Units is a required field
	Units EirpUnits `locationName:"units" type:"string" required:"true" enum:"true"`

	// Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.
	//
	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Eirp) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Eirp) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Eirp"}
	if len(s.Units) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Units"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Eirp) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Units) > 0 {
		v := s.Units

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "units", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Elevation angle of the satellite in the sky during a contact.
type Elevation struct {
	_ struct{} `type:"structure"`

	// Elevation angle units.
	//
	// Unit is a required field
	Unit AngleUnits `locationName:"unit" type:"string" required:"true" enum:"true"`

	// Elevation angle value.
	//
	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Elevation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Elevation) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Information about the endpoint details.
type EndpointDetails struct {
	_ struct{} `type:"structure"`

	// A dataflow endpoint.
	Endpoint *DataflowEndpoint `locationName:"endpoint" type:"structure"`

	// Endpoint security details.
	SecurityDetails *SecurityDetails `locationName:"securityDetails" type:"structure"`
}

// String returns the string representation
func (s EndpointDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EndpointDetails"}
	if s.Endpoint != nil {
		if err := s.Endpoint.Validate(); err != nil {
			invalidParams.AddNested("Endpoint", err.(aws.ErrInvalidParams))
		}
	}
	if s.SecurityDetails != nil {
		if err := s.SecurityDetails.Validate(); err != nil {
			invalidParams.AddNested("SecurityDetails", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Endpoint != nil {
		v := s.Endpoint

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "endpoint", v, metadata)
	}
	if s.SecurityDetails != nil {
		v := s.SecurityDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "securityDetails", v, metadata)
	}
	return nil
}

// Object that describes the frequency.
type Frequency struct {
	_ struct{} `type:"structure"`

	// Frequency units.
	//
	// Units is a required field
	Units FrequencyUnits `locationName:"units" type:"string" required:"true" enum:"true"`

	// Frequency value. Valid values are between 2200 to 2300 MHz and 7750 to 8400
	// MHz for downlink and 2025 to 2120 MHz for uplink.
	//
	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Frequency) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Frequency) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Frequency"}
	if len(s.Units) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Units"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Frequency) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Units) > 0 {
		v := s.Units

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "units", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Object that describes the frequency bandwidth.
type FrequencyBandwidth struct {
	_ struct{} `type:"structure"`

	// Frequency bandwidth units.
	//
	// Units is a required field
	Units BandwidthUnits `locationName:"units" type:"string" required:"true" enum:"true"`

	// Frequency bandwidth value. AWS Ground Station currently has the following
	// bandwidth limitations:
	//
	//    * For AntennaDownlinkDemodDecodeconfig, valid values are between 125 kHz
	//    to 650 MHz.
	//
	//    * For AntennaDownlinkconfig, valid values are between 10 kHz to 54 MHz.
	//
	//    * For AntennaUplinkConfig, valid values are between 10 kHz to 54 MHz.
	//
	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s FrequencyBandwidth) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrequencyBandwidth) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FrequencyBandwidth"}
	if len(s.Units) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Units"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FrequencyBandwidth) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Units) > 0 {
		v := s.Units

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "units", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Information about the ground station data.
type GroundStationData struct {
	_ struct{} `type:"structure"`

	// UUID of a ground station.
	GroundStationId *string `locationName:"groundStationId" type:"string"`

	// Name of a ground station.
	GroundStationName *string `locationName:"groundStationName" type:"string"`

	// Ground station Region.
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s GroundStationData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroundStationData) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroundStationId != nil {
		v := *s.GroundStationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groundStationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroundStationName != nil {
		v := *s.GroundStationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groundStationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Item in a list of mission profiles.
type MissionProfileListItem struct {
	_ struct{} `type:"structure"`

	// ARN of a mission profile.
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	// UUID of a mission profile.
	MissionProfileId *string `locationName:"missionProfileId" type:"string"`

	// Name of a mission profile.
	Name *string `locationName:"name" type:"string"`

	// Region of a mission profile.
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s MissionProfileListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MissionProfileListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.MissionProfileArn != nil {
		v := *s.MissionProfileArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "missionProfileArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MissionProfileId != nil {
		v := *s.MissionProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "missionProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Item in a list of satellites.
type SatelliteListItem struct {
	_ struct{} `type:"structure"`

	// A list of ground stations to which the satellite is on-boarded.
	GroundStations []string `locationName:"groundStations" type:"list"`

	// NORAD satellite ID number.
	NoradSatelliteID *int64 `locationName:"noradSatelliteID" min:"1" type:"integer"`

	// ARN of a satellite.
	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	// UUID of a satellite.
	SatelliteId *string `locationName:"satelliteId" min:"1" type:"string"`
}

// String returns the string representation
func (s SatelliteListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SatelliteListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroundStations != nil {
		v := s.GroundStations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "groundStations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NoradSatelliteID != nil {
		v := *s.NoradSatelliteID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "noradSatelliteID", protocol.Int64Value(v), metadata)
	}
	if s.SatelliteArn != nil {
		v := *s.SatelliteArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "satelliteArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SatelliteId != nil {
		v := *s.SatelliteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "satelliteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about endpoints.
type SecurityDetails struct {
	_ struct{} `type:"structure"`

	// ARN to a role needed for connecting streams to your instances.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The security groups to attach to the elastic network interfaces.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list" required:"true"`

	// A list of subnets where AWS Ground Station places elastic network interfaces
	// to send streams to your instances.
	//
	// SubnetIds is a required field
	SubnetIds []string `locationName:"subnetIds" type:"list" required:"true"`
}

// String returns the string representation
func (s SecurityDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SecurityDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SecurityDetails"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.SecurityGroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroupIds"))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about the socket address.
type SocketAddress struct {
	_ struct{} `type:"structure"`

	// Name of a socket address.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Port of a socket address.
	//
	// Port is a required field
	Port *int64 `locationName:"port" type:"integer" required:"true"`
}

// String returns the string representation
func (s SocketAddress) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SocketAddress) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SocketAddress"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SocketAddress) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Dataflow details for the source side.
type Source struct {
	_ struct{} `type:"structure"`

	// Additional details for a Config, if type is dataflow endpoint or antenna
	// demod decode.
	ConfigDetails *ConfigDetails `locationName:"configDetails" type:"structure"`

	// UUID of a Config.
	ConfigId *string `locationName:"configId" type:"string"`

	// Type of a Config.
	ConfigType ConfigCapabilityType `locationName:"configType" type:"string" enum:"true"`

	// Region of a dataflow source.
	DataflowSourceRegion *string `locationName:"dataflowSourceRegion" type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Source) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigDetails != nil {
		v := s.ConfigDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "configDetails", v, metadata)
	}
	if s.ConfigId != nil {
		v := *s.ConfigId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConfigType) > 0 {
		v := s.ConfigType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DataflowSourceRegion != nil {
		v := *s.DataflowSourceRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowSourceRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Object that describes a spectral Config.
type SpectrumConfig struct {
	_ struct{} `type:"structure"`

	// Bandwidth of a spectral Config. AWS Ground Station currently has the following
	// bandwidth limitations:
	//
	//    * For AntennaDownlinkDemodDecodeconfig, valid values are between 125 kHz
	//    to 650 MHz.
	//
	//    * For AntennaDownlinkconfig valid values are between 10 kHz to 54 MHz.
	//
	//    * For AntennaUplinkConfig, valid values are between 10 kHz to 54 MHz.
	//
	// Bandwidth is a required field
	Bandwidth *FrequencyBandwidth `locationName:"bandwidth" type:"structure" required:"true"`

	// Center frequency of a spectral Config. Valid values are between 2200 to 2300
	// MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
	//
	// CenterFrequency is a required field
	CenterFrequency *Frequency `locationName:"centerFrequency" type:"structure" required:"true"`

	// Polarization of a spectral Config. Capturing both "RIGHT_HAND" and "LEFT_HAND"
	// polarization requires two separate configs.
	Polarization Polarization `locationName:"polarization" type:"string" enum:"true"`
}

// String returns the string representation
func (s SpectrumConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpectrumConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SpectrumConfig"}

	if s.Bandwidth == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bandwidth"))
	}

	if s.CenterFrequency == nil {
		invalidParams.Add(aws.NewErrParamRequired("CenterFrequency"))
	}
	if s.Bandwidth != nil {
		if err := s.Bandwidth.Validate(); err != nil {
			invalidParams.AddNested("Bandwidth", err.(aws.ErrInvalidParams))
		}
	}
	if s.CenterFrequency != nil {
		if err := s.CenterFrequency.Validate(); err != nil {
			invalidParams.AddNested("CenterFrequency", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SpectrumConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bandwidth != nil {
		v := s.Bandwidth

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bandwidth", v, metadata)
	}
	if s.CenterFrequency != nil {
		v := s.CenterFrequency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "centerFrequency", v, metadata)
	}
	if len(s.Polarization) > 0 {
		v := s.Polarization

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "polarization", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Object that determines whether tracking should be used during a contact executed
// with this Config in the mission profile.
type TrackingConfig struct {
	_ struct{} `type:"structure"`

	// Current setting for autotrack.
	//
	// Autotrack is a required field
	Autotrack Criticality `locationName:"autotrack" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TrackingConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrackingConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrackingConfig"}
	if len(s.Autotrack) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Autotrack"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TrackingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Autotrack) > 0 {
		v := s.Autotrack

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autotrack", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about an uplink echo Config.
//
// Parameters from the AntennaUplinkConfig, corresponding to the specified AntennaUplinkConfigArn,
// are used when this UplinkEchoConfig is used in a contact.
type UplinkEchoConfig struct {
	_ struct{} `type:"structure"`

	// ARN of an uplink Config.
	//
	// AntennaUplinkConfigArn is a required field
	AntennaUplinkConfigArn *string `locationName:"antennaUplinkConfigArn" type:"string" required:"true"`

	// Whether or not an uplink Config is enabled.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s UplinkEchoConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UplinkEchoConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UplinkEchoConfig"}

	if s.AntennaUplinkConfigArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AntennaUplinkConfigArn"))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UplinkEchoConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AntennaUplinkConfigArn != nil {
		v := *s.AntennaUplinkConfigArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "antennaUplinkConfigArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Information about the uplink spectral Config.
type UplinkSpectrumConfig struct {
	_ struct{} `type:"structure"`

	// Center frequency of an uplink spectral Config. Valid values are between 2025
	// to 2120 MHz.
	//
	// CenterFrequency is a required field
	CenterFrequency *Frequency `locationName:"centerFrequency" type:"structure" required:"true"`

	// Polarization of an uplink spectral Config. Capturing both "RIGHT_HAND" and
	// "LEFT_HAND" polarization requires two separate configs.
	Polarization Polarization `locationName:"polarization" type:"string" enum:"true"`
}

// String returns the string representation
func (s UplinkSpectrumConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UplinkSpectrumConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UplinkSpectrumConfig"}

	if s.CenterFrequency == nil {
		invalidParams.Add(aws.NewErrParamRequired("CenterFrequency"))
	}
	if s.CenterFrequency != nil {
		if err := s.CenterFrequency.Validate(); err != nil {
			invalidParams.AddNested("CenterFrequency", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UplinkSpectrumConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CenterFrequency != nil {
		v := s.CenterFrequency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "centerFrequency", v, metadata)
	}
	if len(s.Polarization) > 0 {
		v := s.Polarization

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "polarization", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
