// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector to retrieve information about the delegated administrator
	// from.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeOrganizationConfigurationInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeOrganizationConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether GuardDuty is automatically enabled for accounts added to
	// the organization.
	//
	// AutoEnable is a required field
	AutoEnable *bool `locationName:"autoEnable" type:"boolean" required:"true"`

	// Indicates whether the maximum number of allowed member accounts are already
	// associated with the delegated administrator master account.
	//
	// MemberAccountLimitReached is a required field
	MemberAccountLimitReached *bool `locationName:"memberAccountLimitReached" type:"boolean" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeOrganizationConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AutoEnable != nil {
		v := *s.AutoEnable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoEnable", protocol.BoolValue(v), metadata)
	}
	if s.MemberAccountLimitReached != nil {
		v := *s.MemberAccountLimitReached

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "memberAccountLimitReached", protocol.BoolValue(v), metadata)
	}
	return nil
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Returns information about the account selected as the delegated administrator
// for GuardDuty.
//
//    // Example sending a request using DescribeOrganizationConfigurationRequest.
//    req := client.DescribeOrganizationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration
func (c *Client) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) DescribeOrganizationConfigurationRequest {
	op := &aws.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/admin",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	req := c.newRequest(op, input, &DescribeOrganizationConfigurationOutput{})

	return DescribeOrganizationConfigurationRequest{Request: req, Input: input, Copy: c.DescribeOrganizationConfigurationRequest}
}

// DescribeOrganizationConfigurationRequest is the request type for the
// DescribeOrganizationConfiguration API operation.
type DescribeOrganizationConfigurationRequest struct {
	*aws.Request
	Input *DescribeOrganizationConfigurationInput
	Copy  func(*DescribeOrganizationConfigurationInput) DescribeOrganizationConfigurationRequest
}

// Send marshals and sends the DescribeOrganizationConfiguration API request.
func (r DescribeOrganizationConfigurationRequest) Send(ctx context.Context) (*DescribeOrganizationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOrganizationConfigurationResponse{
		DescribeOrganizationConfigurationOutput: r.Request.Data.(*DescribeOrganizationConfigurationOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeOrganizationConfigurationResponse is the response type for the
// DescribeOrganizationConfiguration API operation.
type DescribeOrganizationConfigurationResponse struct {
	*DescribeOrganizationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOrganizationConfiguration request.
func (r *DescribeOrganizationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
