// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type EnableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID for the organization account to be enabled as a GuardDuty
	// delegated administrator.
	//
	// AdminAccountId is a required field
	AdminAccountId *string `locationName:"adminAccountId" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableOrganizationAdminAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableOrganizationAdminAccountInput"}

	if s.AdminAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AdminAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnableOrganizationAdminAccountInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AdminAccountId != nil {
		v := *s.AdminAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adminAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type EnableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnableOrganizationAdminAccountOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opEnableOrganizationAdminAccount = "EnableOrganizationAdminAccount"

// EnableOrganizationAdminAccountRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Enables an AWS account within the organization as the GuardDuty delegated
// administrator.
//
//    // Example sending a request using EnableOrganizationAdminAccountRequest.
//    req := client.EnableOrganizationAdminAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/EnableOrganizationAdminAccount
func (c *Client) EnableOrganizationAdminAccountRequest(input *EnableOrganizationAdminAccountInput) EnableOrganizationAdminAccountRequest {
	op := &aws.Operation{
		Name:       opEnableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/admin/enable",
	}

	if input == nil {
		input = &EnableOrganizationAdminAccountInput{}
	}

	req := c.newRequest(op, input, &EnableOrganizationAdminAccountOutput{})

	return EnableOrganizationAdminAccountRequest{Request: req, Input: input, Copy: c.EnableOrganizationAdminAccountRequest}
}

// EnableOrganizationAdminAccountRequest is the request type for the
// EnableOrganizationAdminAccount API operation.
type EnableOrganizationAdminAccountRequest struct {
	*aws.Request
	Input *EnableOrganizationAdminAccountInput
	Copy  func(*EnableOrganizationAdminAccountInput) EnableOrganizationAdminAccountRequest
}

// Send marshals and sends the EnableOrganizationAdminAccount API request.
func (r EnableOrganizationAdminAccountRequest) Send(ctx context.Context) (*EnableOrganizationAdminAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableOrganizationAdminAccountResponse{
		EnableOrganizationAdminAccountOutput: r.Request.Data.(*EnableOrganizationAdminAccountOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableOrganizationAdminAccountResponse is the response type for the
// EnableOrganizationAdminAccount API operation.
type EnableOrganizationAdminAccountResponse struct {
	*EnableOrganizationAdminAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableOrganizationAdminAccount request.
func (r *EnableOrganizationAdminAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
