// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DisableHealthServiceAccessForOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableHealthServiceAccessForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

type DisableHealthServiceAccessForOrganizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableHealthServiceAccessForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableHealthServiceAccessForOrganization = "DisableHealthServiceAccessForOrganization"

// DisableHealthServiceAccessForOrganizationRequest returns a request value for making API operation for
// AWS Health APIs and Notifications.
//
// Calling this operation disables Health from working with AWS Organizations.
// This does not remove the Service Linked Role (SLR) from the the master account
// in your organization. Use the IAM console, API, or AWS CLI to remove the
// SLR if desired. To call this operation, you must sign in as an IAM user,
// assume an IAM role, or sign in as the root user (not recommended) in the
// organization's master account.
//
//    // Example sending a request using DisableHealthServiceAccessForOrganizationRequest.
//    req := client.DisableHealthServiceAccessForOrganizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DisableHealthServiceAccessForOrganization
func (c *Client) DisableHealthServiceAccessForOrganizationRequest(input *DisableHealthServiceAccessForOrganizationInput) DisableHealthServiceAccessForOrganizationRequest {
	op := &aws.Operation{
		Name:       opDisableHealthServiceAccessForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableHealthServiceAccessForOrganizationInput{}
	}

	req := c.newRequest(op, input, &DisableHealthServiceAccessForOrganizationOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DisableHealthServiceAccessForOrganizationRequest{Request: req, Input: input, Copy: c.DisableHealthServiceAccessForOrganizationRequest}
}

// DisableHealthServiceAccessForOrganizationRequest is the request type for the
// DisableHealthServiceAccessForOrganization API operation.
type DisableHealthServiceAccessForOrganizationRequest struct {
	*aws.Request
	Input *DisableHealthServiceAccessForOrganizationInput
	Copy  func(*DisableHealthServiceAccessForOrganizationInput) DisableHealthServiceAccessForOrganizationRequest
}

// Send marshals and sends the DisableHealthServiceAccessForOrganization API request.
func (r DisableHealthServiceAccessForOrganizationRequest) Send(ctx context.Context) (*DisableHealthServiceAccessForOrganizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableHealthServiceAccessForOrganizationResponse{
		DisableHealthServiceAccessForOrganizationOutput: r.Request.Data.(*DisableHealthServiceAccessForOrganizationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableHealthServiceAccessForOrganizationResponse is the response type for the
// DisableHealthServiceAccessForOrganization API operation.
type DisableHealthServiceAccessForOrganizationResponse struct {
	*DisableHealthServiceAccessForOrganizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableHealthServiceAccessForOrganization request.
func (r *DisableHealthServiceAccessForOrganizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
