// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package honeycode

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetScreenDataInput struct {
	_ struct{} `type:"structure"`

	// The ID of the app that contains the screem.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The number of results to be returned on a single page. Specify a number between
	// 1 and 100. The maximum value is 100.
	//
	// This parameter is optional. If you don't specify this parameter, the default
	// page size is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// This parameter is optional. If a nextToken is not specified, the API returns
	// the first page of data.
	//
	// Pagination tokens expire after 1 hour. If you use a token that was returned
	// more than an hour back, the API will throw ValidationException.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the screen.
	//
	// ScreenId is a required field
	ScreenId *string `locationName:"screenId" type:"string" required:"true"`

	// Variables are optional and are needed only if the screen requires them to
	// render correctly. Variables are specified as a map where the key is the name
	// of the variable as defined on the screen. The value is an object which currently
	// has only one property, rawValue, which holds the value of the variable to
	// be passed to the screen.
	Variables map[string]VariableValue `locationName:"variables" type:"map" sensitive:"true"`

	// The ID of the workbook that contains the screen.
	//
	// WorkbookId is a required field
	WorkbookId *string `locationName:"workbookId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetScreenDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetScreenDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetScreenDataInput"}

	if s.AppId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.ScreenId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScreenId"))
	}

	if s.WorkbookId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkbookId"))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetScreenDataInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AppId != nil {
		v := *s.AppId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "appId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScreenId != nil {
		v := *s.ScreenId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "screenId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.WorkbookId != nil {
		v := *s.WorkbookId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "workbookId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetScreenDataOutput struct {
	_ struct{} `type:"structure"`

	// Provides the pagination token to load the next page if there are more results
	// matching the request. If a pagination token is not present in the response,
	// it means that all data matching the query has been loaded.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A map of all the rows on the screen keyed by block name.
	//
	// Results is a required field
	Results map[string]ResultSet `locationName:"results" type:"map" required:"true"`

	// Indicates the cursor of the workbook at which the data returned by this workbook
	// is read. Workbook cursor keeps increasing with every update and the increments
	// are not sequential.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation
func (s GetScreenDataOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetScreenDataOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Results != nil {
		v := s.Results

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "results", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.WorkbookCursor != nil {
		v := *s.WorkbookCursor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "workbookCursor", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opGetScreenData = "GetScreenData"

// GetScreenDataRequest returns a request value for making API operation for
// Amazon Honeycode.
//
// The GetScreenData API allows retrieval of data from a screen in a Honeycode
// app. The API allows setting local variables in the screen to filter, sort
// or otherwise affect what will be displayed on the screen.
//
//    // Example sending a request using GetScreenDataRequest.
//    req := client.GetScreenDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData
func (c *Client) GetScreenDataRequest(input *GetScreenDataInput) GetScreenDataRequest {
	op := &aws.Operation{
		Name:       opGetScreenData,
		HTTPMethod: "POST",
		HTTPPath:   "/screendata",
	}

	if input == nil {
		input = &GetScreenDataInput{}
	}

	req := c.newRequest(op, input, &GetScreenDataOutput{})

	return GetScreenDataRequest{Request: req, Input: input, Copy: c.GetScreenDataRequest}
}

// GetScreenDataRequest is the request type for the
// GetScreenData API operation.
type GetScreenDataRequest struct {
	*aws.Request
	Input *GetScreenDataInput
	Copy  func(*GetScreenDataInput) GetScreenDataRequest
}

// Send marshals and sends the GetScreenData API request.
func (r GetScreenDataRequest) Send(ctx context.Context) (*GetScreenDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetScreenDataResponse{
		GetScreenDataOutput: r.Request.Data.(*GetScreenDataOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetScreenDataResponse is the response type for the
// GetScreenData API operation.
type GetScreenDataResponse struct {
	*GetScreenDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetScreenData request.
func (r *GetScreenDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
