// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package honeycode

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type InvokeScreenAutomationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the app that contains the screen automation.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The request token for performing the automation action. Request tokens help
	// to identify duplicate requests. If a call times out or fails due to a transient
	// error like a failed network connection, you can retry the call with the same
	// request token. The service ensures that if the first call using that request
	// token is successfully performed, the second call will return the response
	// of the previous call rather than performing the action again.
	//
	// Note that request tokens are valid only for a few minutes. You cannot use
	// request tokens to dedupe requests spanning hours or days.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"32" type:"string"`

	// The row ID for the automation if the automation is defined inside a block
	// with source or list.
	RowId *string `locationName:"rowId" type:"string"`

	// The ID of the automation action to be performed.
	//
	// ScreenAutomationId is a required field
	ScreenAutomationId *string `location:"uri" locationName:"automationId" type:"string" required:"true"`

	// The ID of the screen that contains the screen automation.
	//
	// ScreenId is a required field
	ScreenId *string `location:"uri" locationName:"screenId" type:"string" required:"true"`

	// Variables are optional and are needed only if the screen requires them to
	// render correctly. Variables are specified as a map where the key is the name
	// of the variable as defined on the screen. The value is an object which currently
	// has only one property, rawValue, which holds the value of the variable to
	// be passed to the screen.
	Variables map[string]VariableValue `locationName:"variables" type:"map" sensitive:"true"`

	// The ID of the workbook that contains the screen automation.
	//
	// WorkbookId is a required field
	WorkbookId *string `location:"uri" locationName:"workbookId" type:"string" required:"true"`
}

// String returns the string representation
func (s InvokeScreenAutomationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeScreenAutomationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InvokeScreenAutomationInput"}

	if s.AppId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppId"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 32))
	}

	if s.ScreenAutomationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScreenAutomationId"))
	}

	if s.ScreenId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScreenId"))
	}

	if s.WorkbookId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkbookId"))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvokeScreenAutomationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClientRequestToken != nil {
		v := *s.ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RowId != nil {
		v := *s.RowId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rowId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.AppId != nil {
		v := *s.AppId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "appId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScreenAutomationId != nil {
		v := *s.ScreenAutomationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "automationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScreenId != nil {
		v := *s.ScreenId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "screenId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WorkbookId != nil {
		v := *s.WorkbookId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "workbookId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type InvokeScreenAutomationOutput struct {
	_ struct{} `type:"structure"`

	// The updated workbook cursor after performing the automation action.
	//
	// WorkbookCursor is a required field
	WorkbookCursor *int64 `locationName:"workbookCursor" type:"long" required:"true"`
}

// String returns the string representation
func (s InvokeScreenAutomationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvokeScreenAutomationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.WorkbookCursor != nil {
		v := *s.WorkbookCursor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "workbookCursor", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opInvokeScreenAutomation = "InvokeScreenAutomation"

// InvokeScreenAutomationRequest returns a request value for making API operation for
// Amazon Honeycode.
//
// The InvokeScreenAutomation API allows invoking an action defined in a screen
// in a Honeycode app. The API allows setting local variables, which can then
// be used in the automation being invoked. This allows automating the Honeycode
// app interactions to write, update or delete data in the workbook.
//
//    // Example sending a request using InvokeScreenAutomationRequest.
//    req := client.InvokeScreenAutomationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation
func (c *Client) InvokeScreenAutomationRequest(input *InvokeScreenAutomationInput) InvokeScreenAutomationRequest {
	op := &aws.Operation{
		Name:       opInvokeScreenAutomation,
		HTTPMethod: "POST",
		HTTPPath:   "/workbooks/{workbookId}/apps/{appId}/screens/{screenId}/automations/{automationId}",
	}

	if input == nil {
		input = &InvokeScreenAutomationInput{}
	}

	req := c.newRequest(op, input, &InvokeScreenAutomationOutput{})

	return InvokeScreenAutomationRequest{Request: req, Input: input, Copy: c.InvokeScreenAutomationRequest}
}

// InvokeScreenAutomationRequest is the request type for the
// InvokeScreenAutomation API operation.
type InvokeScreenAutomationRequest struct {
	*aws.Request
	Input *InvokeScreenAutomationInput
	Copy  func(*InvokeScreenAutomationInput) InvokeScreenAutomationRequest
}

// Send marshals and sends the InvokeScreenAutomation API request.
func (r InvokeScreenAutomationRequest) Send(ctx context.Context) (*InvokeScreenAutomationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InvokeScreenAutomationResponse{
		InvokeScreenAutomationOutput: r.Request.Data.(*InvokeScreenAutomationOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InvokeScreenAutomationResponse is the response type for the
// InvokeScreenAutomation API operation.
type InvokeScreenAutomationResponse struct {
	*InvokeScreenAutomationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InvokeScreenAutomation request.
func (r *InvokeScreenAutomationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
