// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DeleteSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider to delete.
	//
	// SAMLProviderArn is a required field
	SAMLProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSAMLProviderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSAMLProviderInput"}

	if s.SAMLProviderArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SAMLProviderArn"))
	}
	if s.SAMLProviderArn != nil && len(*s.SAMLProviderArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("SAMLProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSAMLProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSAMLProvider = "DeleteSAMLProvider"

// DeleteSAMLProviderRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Deletes a SAML provider resource in IAM.
//
// Deleting the provider resource from IAM does not update any roles that reference
// the SAML provider resource's ARN as a principal in their trust policies.
// Any attempt to assume a role that references a non-existent provider resource
// ARN fails.
//
// This operation requires Signature Version 4 (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
//    // Example sending a request using DeleteSAMLProviderRequest.
//    req := client.DeleteSAMLProviderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider
func (c *Client) DeleteSAMLProviderRequest(input *DeleteSAMLProviderInput) DeleteSAMLProviderRequest {
	op := &aws.Operation{
		Name:       opDeleteSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSAMLProviderInput{}
	}

	req := c.newRequest(op, input, &DeleteSAMLProviderOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteSAMLProviderRequest{Request: req, Input: input, Copy: c.DeleteSAMLProviderRequest}
}

// DeleteSAMLProviderRequest is the request type for the
// DeleteSAMLProvider API operation.
type DeleteSAMLProviderRequest struct {
	*aws.Request
	Input *DeleteSAMLProviderInput
	Copy  func(*DeleteSAMLProviderInput) DeleteSAMLProviderRequest
}

// Send marshals and sends the DeleteSAMLProvider API request.
func (r DeleteSAMLProviderRequest) Send(ctx context.Context) (*DeleteSAMLProviderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSAMLProviderResponse{
		DeleteSAMLProviderOutput: r.Request.Data.(*DeleteSAMLProviderOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSAMLProviderResponse is the response type for the
// DeleteSAMLProvider API operation.
type DeleteSAMLProviderResponse struct {
	*DeleteSAMLProviderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSAMLProvider request.
func (r *DeleteSAMLProviderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
