// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DetachUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to detach.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the IAM user to detach the policy from.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachUserPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachUserPolicyInput"}

	if s.PolicyArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyArn", 20))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetachUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetachUserPolicy = "DetachUserPolicy"

// DetachUserPolicyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Removes the specified managed policy from the specified user.
//
// A user can also have inline policies embedded with it. To delete an inline
// policy, use the DeleteUserPolicy API. For information about policies, see
// Managed Policies and Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
//    // Example sending a request using DetachUserPolicyRequest.
//    req := client.DetachUserPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy
func (c *Client) DetachUserPolicyRequest(input *DetachUserPolicyInput) DetachUserPolicyRequest {
	op := &aws.Operation{
		Name:       opDetachUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachUserPolicyInput{}
	}

	req := c.newRequest(op, input, &DetachUserPolicyOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DetachUserPolicyRequest{Request: req, Input: input, Copy: c.DetachUserPolicyRequest}
}

// DetachUserPolicyRequest is the request type for the
// DetachUserPolicy API operation.
type DetachUserPolicyRequest struct {
	*aws.Request
	Input *DetachUserPolicyInput
	Copy  func(*DetachUserPolicyInput) DetachUserPolicyRequest
}

// Send marshals and sends the DetachUserPolicy API request.
func (r DetachUserPolicyRequest) Send(ctx context.Context) (*DetachUserPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachUserPolicyResponse{
		DetachUserPolicyOutput: r.Request.Data.(*DetachUserPolicyOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachUserPolicyResponse is the response type for the
// DetachUserPolicy API operation.
type DetachUserPolicyResponse struct {
	*DetachUserPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachUserPolicy request.
func (r *DetachUserPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
