// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to get information about.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetInstanceProfileInput"}

	if s.InstanceProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful GetInstanceProfile request.
type GetInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the instance profile.
	//
	// InstanceProfile is a required field
	InstanceProfile *InstanceProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetInstanceProfile = "GetInstanceProfile"

// GetInstanceProfileRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves information about the specified instance profile, including the
// instance profile's path, GUID, ARN, and role. For more information about
// instance profiles, see About Instance Profiles (https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html)
// in the IAM User Guide.
//
//    // Example sending a request using GetInstanceProfileRequest.
//    req := client.GetInstanceProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile
func (c *Client) GetInstanceProfileRequest(input *GetInstanceProfileInput) GetInstanceProfileRequest {
	op := &aws.Operation{
		Name:       opGetInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceProfileInput{}
	}

	req := c.newRequest(op, input, &GetInstanceProfileOutput{})

	return GetInstanceProfileRequest{Request: req, Input: input, Copy: c.GetInstanceProfileRequest}
}

// GetInstanceProfileRequest is the request type for the
// GetInstanceProfile API operation.
type GetInstanceProfileRequest struct {
	*aws.Request
	Input *GetInstanceProfileInput
	Copy  func(*GetInstanceProfileInput) GetInstanceProfileRequest
}

// Send marshals and sends the GetInstanceProfile API request.
func (r GetInstanceProfileRequest) Send(ctx context.Context) (*GetInstanceProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetInstanceProfileResponse{
		GetInstanceProfileOutput: r.Request.Data.(*GetInstanceProfileOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetInstanceProfileResponse is the response type for the
// GetInstanceProfile API operation.
type GetInstanceProfileResponse struct {
	*GetInstanceProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetInstanceProfile request.
func (r *GetInstanceProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
