// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UploadServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The contents of the public key certificate in PEM-encoded format.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of the following:
	//
	//    * Any printable ASCII character ranging from the space character (\u0020)
	//    through the end of the ASCII character range
	//
	//    * The printable characters in the Basic Latin and Latin-1 Supplement character
	//    set (through \u00FF)
	//
	//    * The special characters tab (\u0009), line feed (\u000A), and carriage
	//    return (\u000D)
	//
	// CertificateBody is a required field
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The contents of the certificate chain. This is typically a concatenation
	// of the PEM-encoded public key certificates of the chain.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of the following:
	//
	//    * Any printable ASCII character ranging from the space character (\u0020)
	//    through the end of the ASCII character range
	//
	//    * The printable characters in the Basic Latin and Latin-1 Supplement character
	//    set (through \u00FF)
	//
	//    * The special characters tab (\u0009), line feed (\u000A), and carriage
	//    return (\u000D)
	CertificateChain *string `min:"1" type:"string"`

	// The path for the server certificate. For more information about paths, see
	// IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/). This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes. In addition, it
	// can contain any ASCII character from the ! (\u0021) through the DEL character
	// (\u007F), including most punctuation characters, digits, and upper and lowercased
	// letters.
	//
	// If you are uploading a server certificate specifically for use with Amazon
	// CloudFront distributions, you must specify a path using the path parameter.
	// The path must begin with /cloudfront and must include a trailing slash (for
	// example, /cloudfront/test/).
	Path *string `min:"1" type:"string"`

	// The contents of the private key in PEM-encoded format.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of the following:
	//
	//    * Any printable ASCII character ranging from the space character (\u0020)
	//    through the end of the ASCII character range
	//
	//    * The printable characters in the Basic Latin and Latin-1 Supplement character
	//    set (through \u00FF)
	//
	//    * The special characters tab (\u0009), line feed (\u000A), and carriage
	//    return (\u000D)
	//
	// PrivateKey is a required field
	PrivateKey *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The name for the server certificate. Do not include the path in this value.
	// The name of the certificate cannot contain any spaces.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// ServerCertificateName is a required field
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadServerCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UploadServerCertificateInput"}

	if s.CertificateBody == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateBody"))
	}
	if s.CertificateBody != nil && len(*s.CertificateBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateBody", 1))
	}
	if s.CertificateChain != nil && len(*s.CertificateChain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateChain", 1))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Path", 1))
	}

	if s.PrivateKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrivateKey"))
	}
	if s.PrivateKey != nil && len(*s.PrivateKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PrivateKey", 1))
	}

	if s.ServerCertificateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerCertificateName"))
	}
	if s.ServerCertificateName != nil && len(*s.ServerCertificateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerCertificateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful UploadServerCertificate request.
type UploadServerCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The meta information of the uploaded server certificate without its certificate
	// body, certificate chain, and private key.
	ServerCertificateMetadata *ServerCertificateMetadata `type:"structure"`
}

// String returns the string representation
func (s UploadServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opUploadServerCertificate = "UploadServerCertificate"

// UploadServerCertificateRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Uploads a server certificate entity for the AWS account. The server certificate
// entity includes a public key certificate, a private key, and an optional
// certificate chain, which should all be PEM-encoded.
//
// We recommend that you use AWS Certificate Manager (https://docs.aws.amazon.com/acm/)
// to provision, manage, and deploy your server certificates. With ACM you can
// request a certificate, deploy it to AWS resources, and let ACM handle certificate
// renewals for you. Certificates provided by ACM are free. For more information
// about using ACM, see the AWS Certificate Manager User Guide (https://docs.aws.amazon.com/acm/latest/userguide/).
//
// For more information about working with server certificates, see Working
// with Server Certificates (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide. This topic includes a list of AWS services that can
// use the server certificates that you manage with IAM.
//
// For information about the number of server certificates you can upload, see
// Limitations on IAM Entities and Objects (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-limits.html)
// in the IAM User Guide.
//
// Because the body of the public key certificate, private key, and the certificate
// chain can be large, you should use POST rather than GET when calling UploadServerCertificate.
// For information about setting up signatures and authorization through the
// API, go to Signing AWS API Requests (https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
// in the AWS General Reference. For general information about using the Query
// API with IAM, go to Calling the API by Making HTTP Query Requests (https://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html)
// in the IAM User Guide.
//
//    // Example sending a request using UploadServerCertificateRequest.
//    req := client.UploadServerCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadServerCertificate
func (c *Client) UploadServerCertificateRequest(input *UploadServerCertificateInput) UploadServerCertificateRequest {
	op := &aws.Operation{
		Name:       opUploadServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadServerCertificateInput{}
	}

	req := c.newRequest(op, input, &UploadServerCertificateOutput{})

	return UploadServerCertificateRequest{Request: req, Input: input, Copy: c.UploadServerCertificateRequest}
}

// UploadServerCertificateRequest is the request type for the
// UploadServerCertificate API operation.
type UploadServerCertificateRequest struct {
	*aws.Request
	Input *UploadServerCertificateInput
	Copy  func(*UploadServerCertificateInput) UploadServerCertificateRequest
}

// Send marshals and sends the UploadServerCertificate API request.
func (r UploadServerCertificateRequest) Send(ctx context.Context) (*UploadServerCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UploadServerCertificateResponse{
		UploadServerCertificateOutput: r.Request.Data.(*UploadServerCertificateOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UploadServerCertificateResponse is the response type for the
// UploadServerCertificate API operation.
type UploadServerCertificateResponse struct {
	*UploadServerCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UploadServerCertificate request.
func (r *UploadServerCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
