// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteComponentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component build version to delete.
	//
	// ComponentBuildVersionArn is a required field
	ComponentBuildVersionArn *string `location:"querystring" locationName:"componentBuildVersionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteComponentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteComponentInput"}

	if s.ComponentBuildVersionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComponentBuildVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteComponentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ComponentBuildVersionArn != nil {
		v := *s.ComponentBuildVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "componentBuildVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteComponentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component build version that was deleted.
	ComponentBuildVersionArn *string `locationName:"componentBuildVersionArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteComponentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComponentBuildVersionArn != nil {
		v := *s.ComponentBuildVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "componentBuildVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDeleteComponent = "DeleteComponent"

// DeleteComponentRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Deletes a component build version.
//
//    // Example sending a request using DeleteComponentRequest.
//    req := client.DeleteComponentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent
func (c *Client) DeleteComponentRequest(input *DeleteComponentInput) DeleteComponentRequest {
	op := &aws.Operation{
		Name:       opDeleteComponent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteComponent",
	}

	if input == nil {
		input = &DeleteComponentInput{}
	}

	req := c.newRequest(op, input, &DeleteComponentOutput{})

	return DeleteComponentRequest{Request: req, Input: input, Copy: c.DeleteComponentRequest}
}

// DeleteComponentRequest is the request type for the
// DeleteComponent API operation.
type DeleteComponentRequest struct {
	*aws.Request
	Input *DeleteComponentInput
	Copy  func(*DeleteComponentInput) DeleteComponentRequest
}

// Send marshals and sends the DeleteComponent API request.
func (r DeleteComponentRequest) Send(ctx context.Context) (*DeleteComponentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteComponentResponse{
		DeleteComponentOutput: r.Request.Data.(*DeleteComponentOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteComponentResponse is the response type for the
// DeleteComponent API operation.
type DeleteComponentResponse struct {
	*DeleteComponentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteComponent request.
func (r *DeleteComponentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
