// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeExclusionsInput struct {
	_ struct{} `type:"structure"`

	// The list of ARNs that specify the exclusions that you want to describe.
	//
	// ExclusionArns is a required field
	ExclusionArns []string `locationName:"exclusionArns" min:"1" type:"list" required:"true"`

	// The locale into which you want to translate the exclusion's title, description,
	// and recommendation.
	Locale Locale `locationName:"locale" type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeExclusionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExclusionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeExclusionsInput"}

	if s.ExclusionArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExclusionArns"))
	}
	if s.ExclusionArns != nil && len(s.ExclusionArns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExclusionArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeExclusionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the exclusions.
	//
	// Exclusions is a required field
	Exclusions map[string]Exclusion `locationName:"exclusions" min:"1" type:"map" required:"true"`

	// Exclusion details that cannot be described. An error code is provided for
	// each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s DescribeExclusionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeExclusions = "DescribeExclusions"

// DescribeExclusionsRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Describes the exclusions that are specified by the exclusions' ARNs.
//
//    // Example sending a request using DescribeExclusionsRequest.
//    req := client.DescribeExclusionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeExclusions
func (c *Client) DescribeExclusionsRequest(input *DescribeExclusionsInput) DescribeExclusionsRequest {
	op := &aws.Operation{
		Name:       opDescribeExclusions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExclusionsInput{}
	}

	req := c.newRequest(op, input, &DescribeExclusionsOutput{})

	return DescribeExclusionsRequest{Request: req, Input: input, Copy: c.DescribeExclusionsRequest}
}

// DescribeExclusionsRequest is the request type for the
// DescribeExclusions API operation.
type DescribeExclusionsRequest struct {
	*aws.Request
	Input *DescribeExclusionsInput
	Copy  func(*DescribeExclusionsInput) DescribeExclusionsRequest
}

// Send marshals and sends the DescribeExclusions API request.
func (r DescribeExclusionsRequest) Send(ctx context.Context) (*DescribeExclusionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeExclusionsResponse{
		DescribeExclusionsOutput: r.Request.Data.(*DescribeExclusionsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeExclusionsResponse is the response type for the
// DescribeExclusions API operation.
type DescribeExclusionsResponse struct {
	*DescribeExclusionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeExclusions request.
func (r *DescribeExclusionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
