// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AddThingToBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the billing group.
	BillingGroupArn *string `locationName:"billingGroupArn" type:"string"`

	// The name of the billing group.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The ARN of the thing to be added to the billing group.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The name of the thing to be added to the billing group.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s AddThingToBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddThingToBillingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddThingToBillingGroupInput"}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BillingGroupName", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddThingToBillingGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BillingGroupArn != nil {
		v := *s.BillingGroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "billingGroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BillingGroupName != nil {
		v := *s.BillingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "billingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingArn != nil {
		v := *s.ThingArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AddThingToBillingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddThingToBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddThingToBillingGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opAddThingToBillingGroup = "AddThingToBillingGroup"

// AddThingToBillingGroupRequest returns a request value for making API operation for
// AWS IoT.
//
// Adds a thing to a billing group.
//
//    // Example sending a request using AddThingToBillingGroupRequest.
//    req := client.AddThingToBillingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) AddThingToBillingGroupRequest(input *AddThingToBillingGroupInput) AddThingToBillingGroupRequest {
	op := &aws.Operation{
		Name:       opAddThingToBillingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/billing-groups/addThingToBillingGroup",
	}

	if input == nil {
		input = &AddThingToBillingGroupInput{}
	}

	req := c.newRequest(op, input, &AddThingToBillingGroupOutput{})

	return AddThingToBillingGroupRequest{Request: req, Input: input, Copy: c.AddThingToBillingGroupRequest}
}

// AddThingToBillingGroupRequest is the request type for the
// AddThingToBillingGroup API operation.
type AddThingToBillingGroupRequest struct {
	*aws.Request
	Input *AddThingToBillingGroupInput
	Copy  func(*AddThingToBillingGroupInput) AddThingToBillingGroupRequest
}

// Send marshals and sends the AddThingToBillingGroup API request.
func (r AddThingToBillingGroupRequest) Send(ctx context.Context) (*AddThingToBillingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddThingToBillingGroupResponse{
		AddThingToBillingGroupOutput: r.Request.Data.(*AddThingToBillingGroupOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddThingToBillingGroupResponse is the response type for the
// AddThingToBillingGroup API operation.
type AddThingToBillingGroupResponse struct {
	*AddThingToBillingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddThingToBillingGroup request.
func (r *AddThingToBillingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
