// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CancelAuditMitigationActionsTaskInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the task that you want to cancel.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelAuditMitigationActionsTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelAuditMitigationActionsTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelAuditMitigationActionsTaskInput"}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CancelAuditMitigationActionsTaskInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TaskId != nil {
		v := *s.TaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "taskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CancelAuditMitigationActionsTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelAuditMitigationActionsTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CancelAuditMitigationActionsTaskOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opCancelAuditMitigationActionsTask = "CancelAuditMitigationActionsTask"

// CancelAuditMitigationActionsTaskRequest returns a request value for making API operation for
// AWS IoT.
//
// Cancels a mitigation action task that is in progress. If the task is not
// in progress, an InvalidRequestException occurs.
//
//    // Example sending a request using CancelAuditMitigationActionsTaskRequest.
//    req := client.CancelAuditMitigationActionsTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CancelAuditMitigationActionsTaskRequest(input *CancelAuditMitigationActionsTaskInput) CancelAuditMitigationActionsTaskRequest {
	op := &aws.Operation{
		Name:       opCancelAuditMitigationActionsTask,
		HTTPMethod: "PUT",
		HTTPPath:   "/audit/mitigationactions/tasks/{taskId}/cancel",
	}

	if input == nil {
		input = &CancelAuditMitigationActionsTaskInput{}
	}

	req := c.newRequest(op, input, &CancelAuditMitigationActionsTaskOutput{})

	return CancelAuditMitigationActionsTaskRequest{Request: req, Input: input, Copy: c.CancelAuditMitigationActionsTaskRequest}
}

// CancelAuditMitigationActionsTaskRequest is the request type for the
// CancelAuditMitigationActionsTask API operation.
type CancelAuditMitigationActionsTaskRequest struct {
	*aws.Request
	Input *CancelAuditMitigationActionsTaskInput
	Copy  func(*CancelAuditMitigationActionsTaskInput) CancelAuditMitigationActionsTaskRequest
}

// Send marshals and sends the CancelAuditMitigationActionsTask API request.
func (r CancelAuditMitigationActionsTaskRequest) Send(ctx context.Context) (*CancelAuditMitigationActionsTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelAuditMitigationActionsTaskResponse{
		CancelAuditMitigationActionsTaskOutput: r.Request.Data.(*CancelAuditMitigationActionsTaskOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelAuditMitigationActionsTaskResponse is the response type for the
// CancelAuditMitigationActionsTask API operation.
type CancelAuditMitigationActionsTaskResponse struct {
	*CancelAuditMitigationActionsTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelAuditMitigationActionsTask request.
func (r *CancelAuditMitigationActionsTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
