// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ConfirmTopicRuleDestinationInput struct {
	_ struct{} `type:"structure"`

	// The token used to confirm ownership or access to the topic rule confirmation
	// URL.
	//
	// ConfirmationToken is a required field
	ConfirmationToken *string `location:"uri" locationName:"confirmationToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmTopicRuleDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmTopicRuleDestinationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfirmTopicRuleDestinationInput"}

	if s.ConfirmationToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfirmationToken"))
	}
	if s.ConfirmationToken != nil && len(*s.ConfirmationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfirmationToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfirmTopicRuleDestinationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ConfirmationToken != nil {
		v := *s.ConfirmationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "confirmationToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ConfirmTopicRuleDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ConfirmTopicRuleDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfirmTopicRuleDestinationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opConfirmTopicRuleDestination = "ConfirmTopicRuleDestination"

// ConfirmTopicRuleDestinationRequest returns a request value for making API operation for
// AWS IoT.
//
// Confirms a topic rule destination. When you create a rule requiring a destination,
// AWS IoT sends a confirmation message to the endpoint or base address you
// specify. The message includes a token which you pass back when calling ConfirmTopicRuleDestination
// to confirm that you own or have access to the endpoint.
//
//    // Example sending a request using ConfirmTopicRuleDestinationRequest.
//    req := client.ConfirmTopicRuleDestinationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ConfirmTopicRuleDestinationRequest(input *ConfirmTopicRuleDestinationInput) ConfirmTopicRuleDestinationRequest {
	op := &aws.Operation{
		Name:       opConfirmTopicRuleDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/confirmdestination/{confirmationToken+}",
	}

	if input == nil {
		input = &ConfirmTopicRuleDestinationInput{}
	}

	req := c.newRequest(op, input, &ConfirmTopicRuleDestinationOutput{})

	return ConfirmTopicRuleDestinationRequest{Request: req, Input: input, Copy: c.ConfirmTopicRuleDestinationRequest}
}

// ConfirmTopicRuleDestinationRequest is the request type for the
// ConfirmTopicRuleDestination API operation.
type ConfirmTopicRuleDestinationRequest struct {
	*aws.Request
	Input *ConfirmTopicRuleDestinationInput
	Copy  func(*ConfirmTopicRuleDestinationInput) ConfirmTopicRuleDestinationRequest
}

// Send marshals and sends the ConfirmTopicRuleDestination API request.
func (r ConfirmTopicRuleDestinationRequest) Send(ctx context.Context) (*ConfirmTopicRuleDestinationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ConfirmTopicRuleDestinationResponse{
		ConfirmTopicRuleDestinationOutput: r.Request.Data.(*ConfirmTopicRuleDestinationOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ConfirmTopicRuleDestinationResponse is the response type for the
// ConfirmTopicRuleDestination API operation.
type ConfirmTopicRuleDestinationResponse struct {
	*ConfirmTopicRuleDestinationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ConfirmTopicRuleDestination request.
func (r *ConfirmTopicRuleDestinationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
