// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDimensionInput struct {
	_ struct{} `type:"structure"`

	// Each dimension must have a unique client request token. If you try to create
	// a new dimension with the same token as a dimension that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	//
	// ClientRequestToken is a required field
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// A unique identifier for the dimension. Choose something that describes the
	// type and value to make it easy to remember what it does.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies the value or list of values for the dimension. For TOPIC_FILTER
	// dimensions, this is a pattern used to match the MQTT topic (for example,
	// "admin/#").
	//
	// StringValues is a required field
	StringValues []string `locationName:"stringValues" min:"1" type:"list" required:"true"`

	// Metadata that can be used to manage the dimension.
	Tags []Tag `locationName:"tags" type:"list"`

	// Specifies the type of dimension. Supported types: TOPIC_FILTER.
	//
	// Type is a required field
	Type DimensionType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateDimensionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDimensionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDimensionInput"}

	if s.ClientRequestToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientRequestToken"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.StringValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("StringValues"))
	}
	if s.StringValues != nil && len(s.StringValues) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StringValues", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDimensionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StringValues != nil {
		v := s.StringValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "stringValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateDimensionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon resource name) of the created dimension.
	Arn *string `locationName:"arn" type:"string"`

	// A unique identifier for the dimension.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDimensionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDimensionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateDimension = "CreateDimension"

// CreateDimensionRequest returns a request value for making API operation for
// AWS IoT.
//
// Create a dimension that you can use to limit the scope of a metric used in
// a security profile for AWS IoT Device Defender. For example, using a TOPIC_FILTER
// dimension, you can narrow down the scope of the metric only to MQTT topics
// whose name match the pattern specified in the dimension.
//
//    // Example sending a request using CreateDimensionRequest.
//    req := client.CreateDimensionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateDimensionRequest(input *CreateDimensionInput) CreateDimensionRequest {
	op := &aws.Operation{
		Name:       opCreateDimension,
		HTTPMethod: "POST",
		HTTPPath:   "/dimensions/{name}",
	}

	if input == nil {
		input = &CreateDimensionInput{}
	}

	req := c.newRequest(op, input, &CreateDimensionOutput{})

	return CreateDimensionRequest{Request: req, Input: input, Copy: c.CreateDimensionRequest}
}

// CreateDimensionRequest is the request type for the
// CreateDimension API operation.
type CreateDimensionRequest struct {
	*aws.Request
	Input *CreateDimensionInput
	Copy  func(*CreateDimensionInput) CreateDimensionRequest
}

// Send marshals and sends the CreateDimension API request.
func (r CreateDimensionRequest) Send(ctx context.Context) (*CreateDimensionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDimensionResponse{
		CreateDimensionOutput: r.Request.Data.(*CreateDimensionOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDimensionResponse is the response type for the
// CreateDimension API operation.
type CreateDimensionResponse struct {
	*CreateDimensionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDimension request.
func (r *CreateDimensionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
