// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeEventConfigurationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeEventConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeEventConfigurationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

type DescribeEventConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The creation date of the event configuration.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The event configurations.
	EventConfigurations map[string]Configuration `locationName:"eventConfigurations" type:"map"`

	// The date the event configurations were last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`
}

// String returns the string representation
func (s DescribeEventConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeEventConfigurationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.EventConfigurations != nil {
		v := s.EventConfigurations

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "eventConfigurations", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opDescribeEventConfigurations = "DescribeEventConfigurations"

// DescribeEventConfigurationsRequest returns a request value for making API operation for
// AWS IoT.
//
// Describes event configurations.
//
//    // Example sending a request using DescribeEventConfigurationsRequest.
//    req := client.DescribeEventConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeEventConfigurationsRequest(input *DescribeEventConfigurationsInput) DescribeEventConfigurationsRequest {
	op := &aws.Operation{
		Name:       opDescribeEventConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/event-configurations",
	}

	if input == nil {
		input = &DescribeEventConfigurationsInput{}
	}

	req := c.newRequest(op, input, &DescribeEventConfigurationsOutput{})

	return DescribeEventConfigurationsRequest{Request: req, Input: input, Copy: c.DescribeEventConfigurationsRequest}
}

// DescribeEventConfigurationsRequest is the request type for the
// DescribeEventConfigurations API operation.
type DescribeEventConfigurationsRequest struct {
	*aws.Request
	Input *DescribeEventConfigurationsInput
	Copy  func(*DescribeEventConfigurationsInput) DescribeEventConfigurationsRequest
}

// Send marshals and sends the DescribeEventConfigurations API request.
func (r DescribeEventConfigurationsRequest) Send(ctx context.Context) (*DescribeEventConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEventConfigurationsResponse{
		DescribeEventConfigurationsOutput: r.Request.Data.(*DescribeEventConfigurationsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEventConfigurationsResponse is the response type for the
// DescribeEventConfigurations API operation.
type DescribeEventConfigurationsResponse struct {
	*DescribeEventConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEventConfigurations request.
func (r *DescribeEventConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
