// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeProvisioningTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet provisioning template.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProvisioningTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProvisioningTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProvisioningTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeProvisioningTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "templateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeProvisioningTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The date when the fleet provisioning template was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The default fleet template version ID.
	DefaultVersionId *int64 `locationName:"defaultVersionId" type:"integer"`

	// The description of the fleet provisioning template.
	Description *string `locationName:"description" type:"string"`

	// True if the fleet provisioning template is enabled, otherwise false.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The date when the fleet provisioning template was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// Gets information about a pre-provisioned hook.
	PreProvisioningHook *ProvisioningHook `locationName:"preProvisioningHook" type:"structure"`

	// The ARN of the role associated with the provisioning template. This IoT role
	// grants permission to provision a device.
	ProvisioningRoleArn *string `locationName:"provisioningRoleArn" min:"20" type:"string"`

	// The ARN of the fleet provisioning template.
	TemplateArn *string `locationName:"templateArn" type:"string"`

	// The JSON formatted contents of the fleet provisioning template.
	TemplateBody *string `locationName:"templateBody" type:"string"`

	// The name of the fleet provisioning template.
	TemplateName *string `locationName:"templateName" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeProvisioningTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeProvisioningTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DefaultVersionId != nil {
		v := *s.DefaultVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "defaultVersionId", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PreProvisioningHook != nil {
		v := s.PreProvisioningHook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "preProvisioningHook", v, metadata)
	}
	if s.ProvisioningRoleArn != nil {
		v := *s.ProvisioningRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "provisioningRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateArn != nil {
		v := *s.TemplateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateBody != nil {
		v := *s.TemplateBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeProvisioningTemplate = "DescribeProvisioningTemplate"

// DescribeProvisioningTemplateRequest returns a request value for making API operation for
// AWS IoT.
//
// Returns information about a fleet provisioning template.
//
//    // Example sending a request using DescribeProvisioningTemplateRequest.
//    req := client.DescribeProvisioningTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeProvisioningTemplateRequest(input *DescribeProvisioningTemplateInput) DescribeProvisioningTemplateRequest {
	op := &aws.Operation{
		Name:       opDescribeProvisioningTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioning-templates/{templateName}",
	}

	if input == nil {
		input = &DescribeProvisioningTemplateInput{}
	}

	req := c.newRequest(op, input, &DescribeProvisioningTemplateOutput{})

	return DescribeProvisioningTemplateRequest{Request: req, Input: input, Copy: c.DescribeProvisioningTemplateRequest}
}

// DescribeProvisioningTemplateRequest is the request type for the
// DescribeProvisioningTemplate API operation.
type DescribeProvisioningTemplateRequest struct {
	*aws.Request
	Input *DescribeProvisioningTemplateInput
	Copy  func(*DescribeProvisioningTemplateInput) DescribeProvisioningTemplateRequest
}

// Send marshals and sends the DescribeProvisioningTemplate API request.
func (r DescribeProvisioningTemplateRequest) Send(ctx context.Context) (*DescribeProvisioningTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProvisioningTemplateResponse{
		DescribeProvisioningTemplateOutput: r.Request.Data.(*DescribeProvisioningTemplateOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeProvisioningTemplateResponse is the response type for the
// DescribeProvisioningTemplate API operation.
type DescribeProvisioningTemplateResponse struct {
	*DescribeProvisioningTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProvisioningTemplate request.
func (r *DescribeProvisioningTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
