// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeStreamInput struct {
	_ struct{} `type:"structure"`

	// The stream ID.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStreamInput"}

	if s.StreamId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeStreamInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeStreamOutput struct {
	_ struct{} `type:"structure"`

	// Information about the stream.
	StreamInfo *StreamInfo `locationName:"streamInfo" type:"structure"`
}

// String returns the string representation
func (s DescribeStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.StreamInfo != nil {
		v := s.StreamInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "streamInfo", v, metadata)
	}
	return nil
}

const opDescribeStream = "DescribeStream"

// DescribeStreamRequest returns a request value for making API operation for
// AWS IoT.
//
// Gets information about a stream.
//
//    // Example sending a request using DescribeStreamRequest.
//    req := client.DescribeStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeStreamRequest(input *DescribeStreamInput) DescribeStreamRequest {
	op := &aws.Operation{
		Name:       opDescribeStream,
		HTTPMethod: "GET",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &DescribeStreamInput{}
	}

	req := c.newRequest(op, input, &DescribeStreamOutput{})

	return DescribeStreamRequest{Request: req, Input: input, Copy: c.DescribeStreamRequest}
}

// DescribeStreamRequest is the request type for the
// DescribeStream API operation.
type DescribeStreamRequest struct {
	*aws.Request
	Input *DescribeStreamInput
	Copy  func(*DescribeStreamInput) DescribeStreamRequest
}

// Send marshals and sends the DescribeStream API request.
func (r DescribeStreamRequest) Send(ctx context.Context) (*DescribeStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeStreamResponse{
		DescribeStreamOutput: r.Request.Data.(*DescribeStreamOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeStreamResponse is the response type for the
// DescribeStream API operation.
type DescribeStreamResponse struct {
	*DescribeStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeStream request.
func (r *DescribeStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
