// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DetachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy to detach.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The target from which the policy will be detached.
	//
	// Target is a required field
	Target *string `locationName:"target" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachPolicyInput"}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Target != nil {
		v := *s.Target

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "target", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyName != nil {
		v := *s.PolicyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "policyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DetachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDetachPolicy = "DetachPolicy"

// DetachPolicyRequest returns a request value for making API operation for
// AWS IoT.
//
// Detaches a policy from the specified target.
//
//    // Example sending a request using DetachPolicyRequest.
//    req := client.DetachPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DetachPolicyRequest(input *DetachPolicyInput) DetachPolicyRequest {
	op := &aws.Operation{
		Name:       opDetachPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/target-policies/{policyName}",
	}

	if input == nil {
		input = &DetachPolicyInput{}
	}

	req := c.newRequest(op, input, &DetachPolicyOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DetachPolicyRequest{Request: req, Input: input, Copy: c.DetachPolicyRequest}
}

// DetachPolicyRequest is the request type for the
// DetachPolicy API operation.
type DetachPolicyRequest struct {
	*aws.Request
	Input *DetachPolicyInput
	Copy  func(*DetachPolicyInput) DetachPolicyRequest
}

// Send marshals and sends the DetachPolicy API request.
func (r DetachPolicyRequest) Send(ctx context.Context) (*DetachPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachPolicyResponse{
		DetachPolicyOutput: r.Request.Data.(*DetachPolicyOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachPolicyResponse is the response type for the
// DetachPolicy API operation.
type DetachPolicyResponse struct {
	*DetachPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachPolicy request.
func (r *DetachPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
