// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetCardinalityInput struct {
	_ struct{} `type:"structure"`

	// The field to aggregate.
	AggregationField *string `locationName:"aggregationField" min:"1" type:"string"`

	// The name of the index to search.
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The search query.
	//
	// QueryString is a required field
	QueryString *string `locationName:"queryString" min:"1" type:"string" required:"true"`

	// The query version.
	QueryVersion *string `locationName:"queryVersion" type:"string"`
}

// String returns the string representation
func (s GetCardinalityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCardinalityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCardinalityInput"}
	if s.AggregationField != nil && len(*s.AggregationField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AggregationField", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 1))
	}

	if s.QueryString == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCardinalityInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AggregationField != nil {
		v := *s.AggregationField

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "aggregationField", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IndexName != nil {
		v := *s.IndexName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "indexName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueryString != nil {
		v := *s.QueryString

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queryString", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueryVersion != nil {
		v := *s.QueryVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queryVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetCardinalityOutput struct {
	_ struct{} `type:"structure"`

	// The approximate count of unique values that match the query.
	Cardinality *int64 `locationName:"cardinality" type:"integer"`
}

// String returns the string representation
func (s GetCardinalityOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCardinalityOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cardinality != nil {
		v := *s.Cardinality

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cardinality", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opGetCardinality = "GetCardinality"

// GetCardinalityRequest returns a request value for making API operation for
// AWS IoT.
//
// Returns the approximate count of unique values that match the query.
//
//    // Example sending a request using GetCardinalityRequest.
//    req := client.GetCardinalityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetCardinalityRequest(input *GetCardinalityInput) GetCardinalityRequest {
	op := &aws.Operation{
		Name:       opGetCardinality,
		HTTPMethod: "POST",
		HTTPPath:   "/indices/cardinality",
	}

	if input == nil {
		input = &GetCardinalityInput{}
	}

	req := c.newRequest(op, input, &GetCardinalityOutput{})

	return GetCardinalityRequest{Request: req, Input: input, Copy: c.GetCardinalityRequest}
}

// GetCardinalityRequest is the request type for the
// GetCardinality API operation.
type GetCardinalityRequest struct {
	*aws.Request
	Input *GetCardinalityInput
	Copy  func(*GetCardinalityInput) GetCardinalityRequest
}

// Send marshals and sends the GetCardinality API request.
func (r GetCardinalityRequest) Send(ctx context.Context) (*GetCardinalityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCardinalityResponse{
		GetCardinalityOutput: r.Request.Data.(*GetCardinalityOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCardinalityResponse is the response type for the
// GetCardinality API operation.
type GetCardinalityResponse struct {
	*GetCardinalityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCardinality request.
func (r *GetCardinalityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
