// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetPercentilesInput struct {
	_ struct{} `type:"structure"`

	// The field to aggregate.
	AggregationField *string `locationName:"aggregationField" min:"1" type:"string"`

	// The name of the index to search.
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The percentile groups returned.
	Percents []float64 `locationName:"percents" type:"list"`

	// The query string.
	//
	// QueryString is a required field
	QueryString *string `locationName:"queryString" min:"1" type:"string" required:"true"`

	// The query version.
	QueryVersion *string `locationName:"queryVersion" type:"string"`
}

// String returns the string representation
func (s GetPercentilesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPercentilesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPercentilesInput"}
	if s.AggregationField != nil && len(*s.AggregationField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AggregationField", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 1))
	}

	if s.QueryString == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPercentilesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AggregationField != nil {
		v := *s.AggregationField

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "aggregationField", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IndexName != nil {
		v := *s.IndexName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "indexName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Percents != nil {
		v := s.Percents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "percents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Float64Value(v1))
		}
		ls0.End()

	}
	if s.QueryString != nil {
		v := *s.QueryString

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queryString", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueryVersion != nil {
		v := *s.QueryVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queryVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetPercentilesOutput struct {
	_ struct{} `type:"structure"`

	// The percentile values of the aggregated fields.
	Percentiles []PercentPair `locationName:"percentiles" type:"list"`
}

// String returns the string representation
func (s GetPercentilesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPercentilesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Percentiles != nil {
		v := s.Percentiles

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "percentiles", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetPercentiles = "GetPercentiles"

// GetPercentilesRequest returns a request value for making API operation for
// AWS IoT.
//
// Groups the aggregated values that match the query into percentile groupings.
// The default percentile groupings are: 1,5,25,50,75,95,99, although you can
// specify your own when you call GetPercentiles. This function returns a value
// for each percentile group specified (or the default percentile groupings).
// The percentile group "1" contains the aggregated field value that occurs
// in approximately one percent of the values that match the query. The percentile
// group "5" contains the aggregated field value that occurs in approximately
// five percent of the values that match the query, and so on. The result is
// an approximation, the more values that match the query, the more accurate
// the percentile values.
//
//    // Example sending a request using GetPercentilesRequest.
//    req := client.GetPercentilesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetPercentilesRequest(input *GetPercentilesInput) GetPercentilesRequest {
	op := &aws.Operation{
		Name:       opGetPercentiles,
		HTTPMethod: "POST",
		HTTPPath:   "/indices/percentiles",
	}

	if input == nil {
		input = &GetPercentilesInput{}
	}

	req := c.newRequest(op, input, &GetPercentilesOutput{})

	return GetPercentilesRequest{Request: req, Input: input, Copy: c.GetPercentilesRequest}
}

// GetPercentilesRequest is the request type for the
// GetPercentiles API operation.
type GetPercentilesRequest struct {
	*aws.Request
	Input *GetPercentilesInput
	Copy  func(*GetPercentilesInput) GetPercentilesRequest
}

// Send marshals and sends the GetPercentiles API request.
func (r GetPercentilesRequest) Send(ctx context.Context) (*GetPercentilesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPercentilesResponse{
		GetPercentilesOutput: r.Request.Data.(*GetPercentilesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPercentilesResponse is the response type for the
// GetPercentiles API operation.
type GetPercentilesResponse struct {
	*GetPercentilesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPercentiles request.
func (r *GetPercentilesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
