// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListDomainConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The type of service delivered by the endpoint.
	ServiceType ServiceType `location:"querystring" locationName:"serviceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListDomainConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainConfigurationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDomainConfigurationsInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDomainConfigurationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "pageSize", protocol.Int64Value(v), metadata)
	}
	if len(s.ServiceType) > 0 {
		v := s.ServiceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "serviceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListDomainConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain summary information about the user's domain
	// configurations.
	DomainConfigurations []DomainConfigurationSummary `locationName:"domainConfigurations" type:"list"`

	// The marker for the next set of results.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListDomainConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDomainConfigurationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainConfigurations != nil {
		v := s.DomainConfigurations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "domainConfigurations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListDomainConfigurations = "ListDomainConfigurations"

// ListDomainConfigurationsRequest returns a request value for making API operation for
// AWS IoT.
//
// Gets a list of domain configurations for the user. This list is sorted alphabetically
// by domain configuration name.
//
// The domain configuration feature is in public preview and is subject to change.
//
//    // Example sending a request using ListDomainConfigurationsRequest.
//    req := client.ListDomainConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListDomainConfigurationsRequest(input *ListDomainConfigurationsInput) ListDomainConfigurationsRequest {
	op := &aws.Operation{
		Name:       opListDomainConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/domainConfigurations",
	}

	if input == nil {
		input = &ListDomainConfigurationsInput{}
	}

	req := c.newRequest(op, input, &ListDomainConfigurationsOutput{})

	return ListDomainConfigurationsRequest{Request: req, Input: input, Copy: c.ListDomainConfigurationsRequest}
}

// ListDomainConfigurationsRequest is the request type for the
// ListDomainConfigurations API operation.
type ListDomainConfigurationsRequest struct {
	*aws.Request
	Input *ListDomainConfigurationsInput
	Copy  func(*ListDomainConfigurationsInput) ListDomainConfigurationsRequest
}

// Send marshals and sends the ListDomainConfigurations API request.
func (r ListDomainConfigurationsRequest) Send(ctx context.Context) (*ListDomainConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDomainConfigurationsResponse{
		ListDomainConfigurationsOutput: r.Request.Data.(*ListDomainConfigurationsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListDomainConfigurationsResponse is the response type for the
// ListDomainConfigurations API operation.
type ListDomainConfigurationsResponse struct {
	*ListDomainConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDomainConfigurations request.
func (r *ListDomainConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
