// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input for the ListPolicyVersions operation.
type ListPolicyVersionsInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPolicyVersionsInput"}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPolicyVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PolicyName != nil {
		v := *s.PolicyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "policyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The output from the ListPolicyVersions operation.
type ListPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The policy versions.
	PolicyVersions []PolicyVersion `locationName:"policyVersions" type:"list"`
}

// String returns the string representation
func (s ListPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPolicyVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PolicyVersions != nil {
		v := s.PolicyVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "policyVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListPolicyVersions = "ListPolicyVersions"

// ListPolicyVersionsRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists the versions of the specified policy and identifies the default version.
//
//    // Example sending a request using ListPolicyVersionsRequest.
//    req := client.ListPolicyVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListPolicyVersionsRequest(input *ListPolicyVersionsInput) ListPolicyVersionsRequest {
	op := &aws.Operation{
		Name:       opListPolicyVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &ListPolicyVersionsInput{}
	}

	req := c.newRequest(op, input, &ListPolicyVersionsOutput{})

	return ListPolicyVersionsRequest{Request: req, Input: input, Copy: c.ListPolicyVersionsRequest}
}

// ListPolicyVersionsRequest is the request type for the
// ListPolicyVersions API operation.
type ListPolicyVersionsRequest struct {
	*aws.Request
	Input *ListPolicyVersionsInput
	Copy  func(*ListPolicyVersionsInput) ListPolicyVersionsRequest
}

// Send marshals and sends the ListPolicyVersions API request.
func (r ListPolicyVersionsRequest) Send(ctx context.Context) (*ListPolicyVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPolicyVersionsResponse{
		ListPolicyVersionsOutput: r.Request.Data.(*ListPolicyVersionsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListPolicyVersionsResponse is the response type for the
// ListPolicyVersions API operation.
type ListPolicyVersionsResponse struct {
	*ListPolicyVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPolicyVersions request.
func (r *ListPolicyVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
