// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListSecurityProfilesForTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// If true, return child groups too.
	Recursive *bool `location:"querystring" locationName:"recursive" type:"boolean"`

	// The ARN of the target (thing group) whose attached security profiles you
	// want to get.
	//
	// SecurityProfileTargetArn is a required field
	SecurityProfileTargetArn *string `location:"querystring" locationName:"securityProfileTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListSecurityProfilesForTargetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityProfilesForTargetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSecurityProfilesForTargetInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.SecurityProfileTargetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityProfileTargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSecurityProfilesForTargetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Recursive != nil {
		v := *s.Recursive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "recursive", protocol.BoolValue(v), metadata)
	}
	if s.SecurityProfileTargetArn != nil {
		v := *s.SecurityProfileTargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "securityProfileTargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListSecurityProfilesForTargetOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of security profiles and their associated targets.
	SecurityProfileTargetMappings []SecurityProfileTargetMapping `locationName:"securityProfileTargetMappings" type:"list"`
}

// String returns the string representation
func (s ListSecurityProfilesForTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSecurityProfilesForTargetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityProfileTargetMappings != nil {
		v := s.SecurityProfileTargetMappings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityProfileTargetMappings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListSecurityProfilesForTarget = "ListSecurityProfilesForTarget"

// ListSecurityProfilesForTargetRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists the Device Defender security profiles attached to a target (thing group).
//
//    // Example sending a request using ListSecurityProfilesForTargetRequest.
//    req := client.ListSecurityProfilesForTargetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListSecurityProfilesForTargetRequest(input *ListSecurityProfilesForTargetInput) ListSecurityProfilesForTargetRequest {
	op := &aws.Operation{
		Name:       opListSecurityProfilesForTarget,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles-for-target",
	}

	if input == nil {
		input = &ListSecurityProfilesForTargetInput{}
	}

	req := c.newRequest(op, input, &ListSecurityProfilesForTargetOutput{})

	return ListSecurityProfilesForTargetRequest{Request: req, Input: input, Copy: c.ListSecurityProfilesForTargetRequest}
}

// ListSecurityProfilesForTargetRequest is the request type for the
// ListSecurityProfilesForTarget API operation.
type ListSecurityProfilesForTargetRequest struct {
	*aws.Request
	Input *ListSecurityProfilesForTargetInput
	Copy  func(*ListSecurityProfilesForTargetInput) ListSecurityProfilesForTargetRequest
}

// Send marshals and sends the ListSecurityProfilesForTarget API request.
func (r ListSecurityProfilesForTargetRequest) Send(ctx context.Context) (*ListSecurityProfilesForTargetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSecurityProfilesForTargetResponse{
		ListSecurityProfilesForTargetOutput: r.Request.Data.(*ListSecurityProfilesForTargetOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListSecurityProfilesForTargetResponse is the response type for the
// ListSecurityProfilesForTarget API operation.
type ListSecurityProfilesForTargetResponse struct {
	*ListSecurityProfilesForTargetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSecurityProfilesForTarget request.
func (r *ListSecurityProfilesForTargetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
