// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input for the ListThingTypes operation.
type ListThingTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the thing type.
	ThingTypeName *string `location:"querystring" locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListThingTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThingTypesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListThingTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThingTypesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingTypeName != nil {
		v := *s.ThingTypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "thingTypeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The output for the ListThingTypes operation.
type ListThingTypesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The thing types.
	ThingTypes []ThingTypeDefinition `locationName:"thingTypes" type:"list"`
}

// String returns the string representation
func (s ListThingTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThingTypesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingTypes != nil {
		v := s.ThingTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "thingTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListThingTypes = "ListThingTypes"

// ListThingTypesRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists the existing thing types.
//
//    // Example sending a request using ListThingTypesRequest.
//    req := client.ListThingTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListThingTypesRequest(input *ListThingTypesInput) ListThingTypesRequest {
	op := &aws.Operation{
		Name:       opListThingTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-types",
	}

	if input == nil {
		input = &ListThingTypesInput{}
	}

	req := c.newRequest(op, input, &ListThingTypesOutput{})

	return ListThingTypesRequest{Request: req, Input: input, Copy: c.ListThingTypesRequest}
}

// ListThingTypesRequest is the request type for the
// ListThingTypes API operation.
type ListThingTypesRequest struct {
	*aws.Request
	Input *ListThingTypesInput
	Copy  func(*ListThingTypesInput) ListThingTypesRequest
}

// Send marshals and sends the ListThingTypes API request.
func (r ListThingTypesRequest) Send(ctx context.Context) (*ListThingTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListThingTypesResponse{
		ListThingTypesOutput: r.Request.Data.(*ListThingTypesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListThingTypesResponse is the response type for the
// ListThingTypes API operation.
type ListThingTypesResponse struct {
	*ListThingTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListThingTypes request.
func (r *ListThingTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
