// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListThingsInThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// When true, list things in this thing group and in all child groups as well.
	Recursive *bool `location:"querystring" locationName:"recursive" type:"boolean"`

	// The thing group name.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListThingsInThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThingsInThingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListThingsInThingGroupInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ThingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThingsInThingGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ThingGroupName != nil {
		v := *s.ThingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "thingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Recursive != nil {
		v := *s.Recursive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "recursive", protocol.BoolValue(v), metadata)
	}
	return nil
}

type ListThingsInThingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The things in the specified thing group.
	Things []string `locationName:"things" type:"list"`
}

// String returns the string representation
func (s ListThingsInThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThingsInThingGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Things != nil {
		v := s.Things

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "things", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opListThingsInThingGroup = "ListThingsInThingGroup"

// ListThingsInThingGroupRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists the things in the specified group.
//
//    // Example sending a request using ListThingsInThingGroupRequest.
//    req := client.ListThingsInThingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListThingsInThingGroupRequest(input *ListThingsInThingGroupInput) ListThingsInThingGroupRequest {
	op := &aws.Operation{
		Name:       opListThingsInThingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-groups/{thingGroupName}/things",
	}

	if input == nil {
		input = &ListThingsInThingGroupInput{}
	}

	req := c.newRequest(op, input, &ListThingsInThingGroupOutput{})

	return ListThingsInThingGroupRequest{Request: req, Input: input, Copy: c.ListThingsInThingGroupRequest}
}

// ListThingsInThingGroupRequest is the request type for the
// ListThingsInThingGroup API operation.
type ListThingsInThingGroupRequest struct {
	*aws.Request
	Input *ListThingsInThingGroupInput
	Copy  func(*ListThingsInThingGroupInput) ListThingsInThingGroupRequest
}

// Send marshals and sends the ListThingsInThingGroup API request.
func (r ListThingsInThingGroupRequest) Send(ctx context.Context) (*ListThingsInThingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListThingsInThingGroupResponse{
		ListThingsInThingGroupOutput: r.Request.Data.(*ListThingsInThingGroupOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListThingsInThingGroupResponse is the response type for the
// ListThingsInThingGroup API operation.
type ListThingsInThingGroupResponse struct {
	*ListThingsInThingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListThingsInThingGroup request.
func (r *ListThingsInThingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
