// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input to the RegisterCACertificate operation.
type RegisterCACertificateInput struct {
	_ struct{} `type:"structure"`

	// Allows this CA certificate to be used for auto registration of device certificates.
	AllowAutoRegistration *bool `location:"querystring" locationName:"allowAutoRegistration" type:"boolean"`

	// The CA certificate.
	//
	// CaCertificate is a required field
	CaCertificate *string `locationName:"caCertificate" min:"1" type:"string" required:"true"`

	// Information about the registration configuration.
	RegistrationConfig *RegistrationConfig `locationName:"registrationConfig" type:"structure"`

	// A boolean value that specifies if the CA certificate is set to active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`

	// Metadata which can be used to manage the CA certificate.
	//
	// For URI Request parameters use format: ...key1=value1&key2=value2...
	//
	// For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
	//
	// For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
	Tags []Tag `locationName:"tags" type:"list"`

	// The private key verification certificate.
	//
	// VerificationCertificate is a required field
	VerificationCertificate *string `locationName:"verificationCertificate" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterCACertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterCACertificateInput"}

	if s.CaCertificate == nil {
		invalidParams.Add(aws.NewErrParamRequired("CaCertificate"))
	}
	if s.CaCertificate != nil && len(*s.CaCertificate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CaCertificate", 1))
	}

	if s.VerificationCertificate == nil {
		invalidParams.Add(aws.NewErrParamRequired("VerificationCertificate"))
	}
	if s.VerificationCertificate != nil && len(*s.VerificationCertificate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VerificationCertificate", 1))
	}
	if s.RegistrationConfig != nil {
		if err := s.RegistrationConfig.Validate(); err != nil {
			invalidParams.AddNested("RegistrationConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RegisterCACertificateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CaCertificate != nil {
		v := *s.CaCertificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "caCertificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegistrationConfig != nil {
		v := s.RegistrationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "registrationConfig", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VerificationCertificate != nil {
		v := *s.VerificationCertificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "verificationCertificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AllowAutoRegistration != nil {
		v := *s.AllowAutoRegistration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "allowAutoRegistration", protocol.BoolValue(v), metadata)
	}
	if s.SetAsActive != nil {
		v := *s.SetAsActive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "setAsActive", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The output from the RegisterCACertificateResponse operation.
type RegisterCACertificateOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The CA certificate identifier.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`
}

// String returns the string representation
func (s RegisterCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RegisterCACertificateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateId != nil {
		v := *s.CertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opRegisterCACertificate = "RegisterCACertificate"

// RegisterCACertificateRequest returns a request value for making API operation for
// AWS IoT.
//
// Registers a CA certificate with AWS IoT. This CA certificate can then be
// used to sign device certificates, which can be then registered with AWS IoT.
// You can register up to 10 CA certificates per AWS account that have the same
// subject field. This enables you to have up to 10 certificate authorities
// sign your device certificates. If you have more than one CA certificate registered,
// make sure you pass the CA certificate when you register your device certificates
// with the RegisterCertificate API.
//
//    // Example sending a request using RegisterCACertificateRequest.
//    req := client.RegisterCACertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) RegisterCACertificateRequest(input *RegisterCACertificateInput) RegisterCACertificateRequest {
	op := &aws.Operation{
		Name:       opRegisterCACertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/cacertificate",
	}

	if input == nil {
		input = &RegisterCACertificateInput{}
	}

	req := c.newRequest(op, input, &RegisterCACertificateOutput{})

	return RegisterCACertificateRequest{Request: req, Input: input, Copy: c.RegisterCACertificateRequest}
}

// RegisterCACertificateRequest is the request type for the
// RegisterCACertificate API operation.
type RegisterCACertificateRequest struct {
	*aws.Request
	Input *RegisterCACertificateInput
	Copy  func(*RegisterCACertificateInput) RegisterCACertificateRequest
}

// Send marshals and sends the RegisterCACertificate API request.
func (r RegisterCACertificateRequest) Send(ctx context.Context) (*RegisterCACertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterCACertificateResponse{
		RegisterCACertificateOutput: r.Request.Data.(*RegisterCACertificateOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterCACertificateResponse is the response type for the
// RegisterCACertificate API operation.
type RegisterCACertificateResponse struct {
	*RegisterCACertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterCACertificate request.
func (r *RegisterCACertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
