// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type SearchIndexInput struct {
	_ struct{} `type:"structure"`

	// The search index name.
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The search query string.
	//
	// QueryString is a required field
	QueryString *string `locationName:"queryString" min:"1" type:"string" required:"true"`

	// The query version.
	QueryVersion *string `locationName:"queryVersion" type:"string"`
}

// String returns the string representation
func (s SearchIndexInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchIndexInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchIndexInput"}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.QueryString == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchIndexInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.IndexName != nil {
		v := *s.IndexName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "indexName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueryString != nil {
		v := *s.QueryString

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queryString", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueryVersion != nil {
		v := *s.QueryVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queryVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type SearchIndexOutput struct {
	_ struct{} `type:"structure"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The thing groups that match the search query.
	ThingGroups []ThingGroupDocument `locationName:"thingGroups" type:"list"`

	// The things that match the search query.
	Things []ThingDocument `locationName:"things" type:"list"`
}

// String returns the string representation
func (s SearchIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchIndexOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingGroups != nil {
		v := s.ThingGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "thingGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Things != nil {
		v := s.Things

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "things", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opSearchIndex = "SearchIndex"

// SearchIndexRequest returns a request value for making API operation for
// AWS IoT.
//
// The query search index.
//
//    // Example sending a request using SearchIndexRequest.
//    req := client.SearchIndexRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) SearchIndexRequest(input *SearchIndexInput) SearchIndexRequest {
	op := &aws.Operation{
		Name:       opSearchIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/indices/search",
	}

	if input == nil {
		input = &SearchIndexInput{}
	}

	req := c.newRequest(op, input, &SearchIndexOutput{})

	return SearchIndexRequest{Request: req, Input: input, Copy: c.SearchIndexRequest}
}

// SearchIndexRequest is the request type for the
// SearchIndex API operation.
type SearchIndexRequest struct {
	*aws.Request
	Input *SearchIndexInput
	Copy  func(*SearchIndexInput) SearchIndexRequest
}

// Send marshals and sends the SearchIndex API request.
func (r SearchIndexRequest) Send(ctx context.Context) (*SearchIndexResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchIndexResponse{
		SearchIndexOutput: r.Request.Data.(*SearchIndexOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SearchIndexResponse is the response type for the
// SearchIndex API operation.
type SearchIndexResponse struct {
	*SearchIndexOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchIndex request.
func (r *SearchIndexResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
