// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type SetDefaultAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// The authorizer name.
	//
	// AuthorizerName is a required field
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetDefaultAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDefaultAuthorizerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetDefaultAuthorizerInput"}

	if s.AuthorizerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthorizerName"))
	}
	if s.AuthorizerName != nil && len(*s.AuthorizerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthorizerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetDefaultAuthorizerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuthorizerName != nil {
		v := *s.AuthorizerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type SetDefaultAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`
}

// String returns the string representation
func (s SetDefaultAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetDefaultAuthorizerOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizerArn != nil {
		v := *s.AuthorizerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerName != nil {
		v := *s.AuthorizerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opSetDefaultAuthorizer = "SetDefaultAuthorizer"

// SetDefaultAuthorizerRequest returns a request value for making API operation for
// AWS IoT.
//
// Sets the default authorizer. This will be used if a websocket connection
// is made without specifying an authorizer.
//
//    // Example sending a request using SetDefaultAuthorizerRequest.
//    req := client.SetDefaultAuthorizerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) SetDefaultAuthorizerRequest(input *SetDefaultAuthorizerInput) SetDefaultAuthorizerRequest {
	op := &aws.Operation{
		Name:       opSetDefaultAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/default-authorizer",
	}

	if input == nil {
		input = &SetDefaultAuthorizerInput{}
	}

	req := c.newRequest(op, input, &SetDefaultAuthorizerOutput{})

	return SetDefaultAuthorizerRequest{Request: req, Input: input, Copy: c.SetDefaultAuthorizerRequest}
}

// SetDefaultAuthorizerRequest is the request type for the
// SetDefaultAuthorizer API operation.
type SetDefaultAuthorizerRequest struct {
	*aws.Request
	Input *SetDefaultAuthorizerInput
	Copy  func(*SetDefaultAuthorizerInput) SetDefaultAuthorizerRequest
}

// Send marshals and sends the SetDefaultAuthorizer API request.
func (r SetDefaultAuthorizerRequest) Send(ctx context.Context) (*SetDefaultAuthorizerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetDefaultAuthorizerResponse{
		SetDefaultAuthorizerOutput: r.Request.Data.(*SetDefaultAuthorizerOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetDefaultAuthorizerResponse is the response type for the
// SetDefaultAuthorizer API operation.
type SetDefaultAuthorizerResponse struct {
	*SetDefaultAuthorizerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetDefaultAuthorizer request.
func (r *SetDefaultAuthorizerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
