// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateDimensionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the dimension. Choose something that describes the
	// type and value to make it easy to remember what it does.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies the value or list of values for the dimension. For TOPIC_FILTER
	// dimensions, this is a pattern used to match the MQTT topic (for example,
	// "admin/#").
	//
	// StringValues is a required field
	StringValues []string `locationName:"stringValues" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateDimensionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDimensionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDimensionInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.StringValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("StringValues"))
	}
	if s.StringValues != nil && len(s.StringValues) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StringValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDimensionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.StringValues != nil {
		v := s.StringValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "stringValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateDimensionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon resource name) of the created dimension.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time, in milliseconds since epoch, when the dimension was initially
	// created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The date and time, in milliseconds since epoch, when the dimension was most
	// recently updated.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// A unique identifier for the dimension.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The value or list of values used to scope the dimension. For example, for
	// topic filters, this is the pattern used to match the MQTT topic name.
	StringValues []string `locationName:"stringValues" min:"1" type:"list"`

	// The type of the dimension.
	Type DimensionType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateDimensionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDimensionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StringValues != nil {
		v := s.StringValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "stringValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opUpdateDimension = "UpdateDimension"

// UpdateDimensionRequest returns a request value for making API operation for
// AWS IoT.
//
// Updates the definition for a dimension. You cannot change the type of a dimension
// after it is created (you can delete it and re-create it).
//
//    // Example sending a request using UpdateDimensionRequest.
//    req := client.UpdateDimensionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateDimensionRequest(input *UpdateDimensionInput) UpdateDimensionRequest {
	op := &aws.Operation{
		Name:       opUpdateDimension,
		HTTPMethod: "PATCH",
		HTTPPath:   "/dimensions/{name}",
	}

	if input == nil {
		input = &UpdateDimensionInput{}
	}

	req := c.newRequest(op, input, &UpdateDimensionOutput{})

	return UpdateDimensionRequest{Request: req, Input: input, Copy: c.UpdateDimensionRequest}
}

// UpdateDimensionRequest is the request type for the
// UpdateDimension API operation.
type UpdateDimensionRequest struct {
	*aws.Request
	Input *UpdateDimensionInput
	Copy  func(*UpdateDimensionInput) UpdateDimensionRequest
}

// Send marshals and sends the UpdateDimension API request.
func (r UpdateDimensionRequest) Send(ctx context.Context) (*UpdateDimensionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDimensionResponse{
		UpdateDimensionOutput: r.Request.Data.(*UpdateDimensionOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDimensionResponse is the response type for the
// UpdateDimension API operation.
type UpdateDimensionResponse struct {
	*UpdateDimensionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDimension request.
func (r *UpdateDimensionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
