// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateDomainConfigurationInput struct {
	_ struct{} `type:"structure"`

	// An object that specifies the authorization service for a domain.
	AuthorizerConfig *AuthorizerConfig `locationName:"authorizerConfig" type:"structure"`

	// The name of the domain configuration to be updated.
	//
	// DomainConfigurationName is a required field
	DomainConfigurationName *string `location:"uri" locationName:"domainConfigurationName" min:"1" type:"string" required:"true"`

	// The status to which the domain configuration should be updated.
	DomainConfigurationStatus DomainConfigurationStatus `locationName:"domainConfigurationStatus" type:"string" enum:"true"`

	// Removes the authorization configuration from a domain.
	RemoveAuthorizerConfig *bool `locationName:"removeAuthorizerConfig" type:"boolean"`
}

// String returns the string representation
func (s UpdateDomainConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDomainConfigurationInput"}

	if s.DomainConfigurationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainConfigurationName"))
	}
	if s.DomainConfigurationName != nil && len(*s.DomainConfigurationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainConfigurationName", 1))
	}
	if s.AuthorizerConfig != nil {
		if err := s.AuthorizerConfig.Validate(); err != nil {
			invalidParams.AddNested("AuthorizerConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDomainConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuthorizerConfig != nil {
		v := s.AuthorizerConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "authorizerConfig", v, metadata)
	}
	if len(s.DomainConfigurationStatus) > 0 {
		v := s.DomainConfigurationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainConfigurationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RemoveAuthorizerConfig != nil {
		v := *s.RemoveAuthorizerConfig

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "removeAuthorizerConfig", protocol.BoolValue(v), metadata)
	}
	if s.DomainConfigurationName != nil {
		v := *s.DomainConfigurationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "domainConfigurationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateDomainConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the domain configuration that was updated.
	DomainConfigurationArn *string `locationName:"domainConfigurationArn" type:"string"`

	// The name of the domain configuration that was updated.
	DomainConfigurationName *string `locationName:"domainConfigurationName" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateDomainConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDomainConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainConfigurationArn != nil {
		v := *s.DomainConfigurationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainConfigurationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainConfigurationName != nil {
		v := *s.DomainConfigurationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainConfigurationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateDomainConfiguration = "UpdateDomainConfiguration"

// UpdateDomainConfigurationRequest returns a request value for making API operation for
// AWS IoT.
//
// Updates values stored in the domain configuration. Domain configurations
// for default endpoints can't be updated.
//
// The domain configuration feature is in public preview and is subject to change.
//
//    // Example sending a request using UpdateDomainConfigurationRequest.
//    req := client.UpdateDomainConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateDomainConfigurationRequest(input *UpdateDomainConfigurationInput) UpdateDomainConfigurationRequest {
	op := &aws.Operation{
		Name:       opUpdateDomainConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/domainConfigurations/{domainConfigurationName}",
	}

	if input == nil {
		input = &UpdateDomainConfigurationInput{}
	}

	req := c.newRequest(op, input, &UpdateDomainConfigurationOutput{})

	return UpdateDomainConfigurationRequest{Request: req, Input: input, Copy: c.UpdateDomainConfigurationRequest}
}

// UpdateDomainConfigurationRequest is the request type for the
// UpdateDomainConfiguration API operation.
type UpdateDomainConfigurationRequest struct {
	*aws.Request
	Input *UpdateDomainConfigurationInput
	Copy  func(*UpdateDomainConfigurationInput) UpdateDomainConfigurationRequest
}

// Send marshals and sends the UpdateDomainConfiguration API request.
func (r UpdateDomainConfigurationRequest) Send(ctx context.Context) (*UpdateDomainConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDomainConfigurationResponse{
		UpdateDomainConfigurationOutput: r.Request.Data.(*UpdateDomainConfigurationOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDomainConfigurationResponse is the response type for the
// UpdateDomainConfiguration API operation.
type UpdateDomainConfigurationResponse struct {
	*UpdateDomainConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDomainConfiguration request.
func (r *UpdateDomainConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
