// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateMitigationActionInput struct {
	_ struct{} `type:"structure"`

	// The friendly name for the mitigation action. You can't change the name by
	// using UpdateMitigationAction. Instead, you must delete and re-create the
	// mitigation action with the new name.
	//
	// ActionName is a required field
	ActionName *string `location:"uri" locationName:"actionName" type:"string" required:"true"`

	// Defines the type of action and the parameters for that action.
	ActionParams *MitigationActionParams `locationName:"actionParams" type:"structure"`

	// The ARN of the IAM role that is used to apply the mitigation action.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateMitigationActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMitigationActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateMitigationActionInput"}

	if s.ActionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActionName"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}
	if s.ActionParams != nil {
		if err := s.ActionParams.Validate(); err != nil {
			invalidParams.AddNested("ActionParams", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMitigationActionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ActionParams != nil {
		v := s.ActionParams

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "actionParams", v, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ActionName != nil {
		v := *s.ActionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "actionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateMitigationActionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the new mitigation action.
	ActionArn *string `locationName:"actionArn" type:"string"`

	// A unique identifier for the mitigation action.
	ActionId *string `locationName:"actionId" type:"string"`
}

// String returns the string representation
func (s UpdateMitigationActionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMitigationActionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionArn != nil {
		v := *s.ActionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ActionId != nil {
		v := *s.ActionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateMitigationAction = "UpdateMitigationAction"

// UpdateMitigationActionRequest returns a request value for making API operation for
// AWS IoT.
//
// Updates the definition for the specified mitigation action.
//
//    // Example sending a request using UpdateMitigationActionRequest.
//    req := client.UpdateMitigationActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateMitigationActionRequest(input *UpdateMitigationActionInput) UpdateMitigationActionRequest {
	op := &aws.Operation{
		Name:       opUpdateMitigationAction,
		HTTPMethod: "PATCH",
		HTTPPath:   "/mitigationactions/actions/{actionName}",
	}

	if input == nil {
		input = &UpdateMitigationActionInput{}
	}

	req := c.newRequest(op, input, &UpdateMitigationActionOutput{})

	return UpdateMitigationActionRequest{Request: req, Input: input, Copy: c.UpdateMitigationActionRequest}
}

// UpdateMitigationActionRequest is the request type for the
// UpdateMitigationAction API operation.
type UpdateMitigationActionRequest struct {
	*aws.Request
	Input *UpdateMitigationActionInput
	Copy  func(*UpdateMitigationActionInput) UpdateMitigationActionRequest
}

// Send marshals and sends the UpdateMitigationAction API request.
func (r UpdateMitigationActionRequest) Send(ctx context.Context) (*UpdateMitigationActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateMitigationActionResponse{
		UpdateMitigationActionOutput: r.Request.Data.(*UpdateMitigationActionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateMitigationActionResponse is the response type for the
// UpdateMitigationAction API operation.
type UpdateMitigationActionResponse struct {
	*UpdateMitigationActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateMitigationAction request.
func (r *UpdateMitigationActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
