// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateTopicRuleDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the topic rule destination.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The status of the topic rule destination. Valid values are:
	//
	// IN_PROGRESS
	//
	// A topic rule destination was created but has not been confirmed. You can
	// set status to IN_PROGRESS by calling UpdateTopicRuleDestination. Calling
	// UpdateTopicRuleDestination causes a new confirmation challenge to be sent
	// to your confirmation endpoint.
	//
	// ENABLED
	//
	// Confirmation was completed, and traffic to this destination is allowed. You
	// can set status to DISABLED by calling UpdateTopicRuleDestination.
	//
	// DISABLED
	//
	// Confirmation was completed, and traffic to this destination is not allowed.
	// You can set status to ENABLED by calling UpdateTopicRuleDestination.
	//
	// ERROR
	//
	// Confirmation could not be completed, for example if the confirmation timed
	// out. You can call GetTopicRuleDestination for details about the error. You
	// can set status to IN_PROGRESS by calling UpdateTopicRuleDestination. Calling
	// UpdateTopicRuleDestination causes a new confirmation challenge to be sent
	// to your confirmation endpoint.
	//
	// Status is a required field
	Status TopicRuleDestinationStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateTopicRuleDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTopicRuleDestinationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateTopicRuleDestinationInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateTopicRuleDestinationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type UpdateTopicRuleDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateTopicRuleDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateTopicRuleDestinationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateTopicRuleDestination = "UpdateTopicRuleDestination"

// UpdateTopicRuleDestinationRequest returns a request value for making API operation for
// AWS IoT.
//
// Updates a topic rule destination. You use this to change the status, endpoint
// URL, or confirmation URL of the destination.
//
//    // Example sending a request using UpdateTopicRuleDestinationRequest.
//    req := client.UpdateTopicRuleDestinationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateTopicRuleDestinationRequest(input *UpdateTopicRuleDestinationInput) UpdateTopicRuleDestinationRequest {
	op := &aws.Operation{
		Name:       opUpdateTopicRuleDestination,
		HTTPMethod: "PATCH",
		HTTPPath:   "/destinations",
	}

	if input == nil {
		input = &UpdateTopicRuleDestinationInput{}
	}

	req := c.newRequest(op, input, &UpdateTopicRuleDestinationOutput{})

	return UpdateTopicRuleDestinationRequest{Request: req, Input: input, Copy: c.UpdateTopicRuleDestinationRequest}
}

// UpdateTopicRuleDestinationRequest is the request type for the
// UpdateTopicRuleDestination API operation.
type UpdateTopicRuleDestinationRequest struct {
	*aws.Request
	Input *UpdateTopicRuleDestinationInput
	Copy  func(*UpdateTopicRuleDestinationInput) UpdateTopicRuleDestinationRequest
}

// Send marshals and sends the UpdateTopicRuleDestination API request.
func (r UpdateTopicRuleDestinationRequest) Send(ctx context.Context) (*UpdateTopicRuleDestinationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateTopicRuleDestinationResponse{
		UpdateTopicRuleDestinationOutput: r.Request.Data.(*UpdateTopicRuleDestinationOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateTopicRuleDestinationResponse is the response type for the
// UpdateTopicRuleDestination API operation.
type UpdateTopicRuleDestinationResponse struct {
	*UpdateTopicRuleDestinationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateTopicRuleDestination request.
func (r *UpdateTopicRuleDestinationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
