// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot1clickdevicesservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeDeviceInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeviceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDeviceInput"}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDeviceInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Device details.
	DeviceDescription *DeviceDescription `locationName:"deviceDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeDeviceOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeviceDescription != nil {
		v := s.DeviceDescription

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deviceDescription", v, metadata)
	}
	return nil
}

const opDescribeDevice = "DescribeDevice"

// DescribeDeviceRequest returns a request value for making API operation for
// AWS IoT 1-Click Devices Service.
//
// Given a device ID, returns a DescribeDeviceResponse object describing the
// details of the device.
//
//    // Example sending a request using DescribeDeviceRequest.
//    req := client.DescribeDeviceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/DescribeDevice
func (c *Client) DescribeDeviceRequest(input *DescribeDeviceInput) DescribeDeviceRequest {
	op := &aws.Operation{
		Name:       opDescribeDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/devices/{deviceId}",
	}

	if input == nil {
		input = &DescribeDeviceInput{}
	}

	req := c.newRequest(op, input, &DescribeDeviceOutput{})

	return DescribeDeviceRequest{Request: req, Input: input, Copy: c.DescribeDeviceRequest}
}

// DescribeDeviceRequest is the request type for the
// DescribeDevice API operation.
type DescribeDeviceRequest struct {
	*aws.Request
	Input *DescribeDeviceInput
	Copy  func(*DescribeDeviceInput) DescribeDeviceRequest
}

// Send marshals and sends the DescribeDevice API request.
func (r DescribeDeviceRequest) Send(ctx context.Context) (*DescribeDeviceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDeviceResponse{
		DescribeDeviceOutput: r.Request.Data.(*DescribeDeviceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDeviceResponse is the response type for the
// DescribeDevice API operation.
type DescribeDeviceResponse struct {
	*DescribeDeviceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDevice request.
func (r *DescribeDeviceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
