// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotdataplane

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListNamedShadowsForThingInput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListNamedShadowsForThingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNamedShadowsForThingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListNamedShadowsForThingInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("PageSize", 1))
	}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListNamedShadowsForThingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "pageSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

type ListNamedShadowsForThingOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of shadows for the specified thing.
	Results []string `locationName:"results" type:"list"`

	// The Epoch date and time the response was generated by AWS IoT.
	Timestamp *int64 `locationName:"timestamp" type:"long"`
}

// String returns the string representation
func (s ListNamedShadowsForThingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListNamedShadowsForThingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Results != nil {
		v := s.Results

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "results", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timestamp", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opListNamedShadowsForThing = "ListNamedShadowsForThing"

// ListNamedShadowsForThingRequest returns a request value for making API operation for
// AWS IoT Data Plane.
//
// Lists the shadows for the specified thing.
//
//    // Example sending a request using ListNamedShadowsForThingRequest.
//    req := client.ListNamedShadowsForThingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListNamedShadowsForThingRequest(input *ListNamedShadowsForThingInput) ListNamedShadowsForThingRequest {
	op := &aws.Operation{
		Name:       opListNamedShadowsForThing,
		HTTPMethod: "GET",
		HTTPPath:   "/api/things/shadow/ListNamedShadowsForThing/{thingName}",
	}

	if input == nil {
		input = &ListNamedShadowsForThingInput{}
	}

	req := c.newRequest(op, input, &ListNamedShadowsForThingOutput{})

	return ListNamedShadowsForThingRequest{Request: req, Input: input, Copy: c.ListNamedShadowsForThingRequest}
}

// ListNamedShadowsForThingRequest is the request type for the
// ListNamedShadowsForThing API operation.
type ListNamedShadowsForThingRequest struct {
	*aws.Request
	Input *ListNamedShadowsForThingInput
	Copy  func(*ListNamedShadowsForThingInput) ListNamedShadowsForThingRequest
}

// Send marshals and sends the ListNamedShadowsForThing API request.
func (r ListNamedShadowsForThingRequest) Send(ctx context.Context) (*ListNamedShadowsForThingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListNamedShadowsForThingResponse{
		ListNamedShadowsForThingOutput: r.Request.Data.(*ListNamedShadowsForThingOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListNamedShadowsForThingResponse is the response type for the
// ListNamedShadowsForThing API operation.
type ListNamedShadowsForThingResponse struct {
	*ListNamedShadowsForThingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListNamedShadowsForThing request.
func (r *ListNamedShadowsForThingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
