// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ioteventsdata

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type BatchPutMessageInput struct {
	_ struct{} `type:"structure"`

	// The list of messages to send. Each message has the following format: '{ "messageId":
	// "string", "inputName": "string", "payload": "string"}'
	//
	// Messages is a required field
	Messages []Message `locationName:"messages" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutMessageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutMessageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchPutMessageInput"}

	if s.Messages == nil {
		invalidParams.Add(aws.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil && len(s.Messages) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Messages", 1))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchPutMessageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Messages != nil {
		v := s.Messages

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "messages", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

type BatchPutMessageOutput struct {
	_ struct{} `type:"structure"`

	// A list of any errors encountered when sending the messages.
	BatchPutMessageErrorEntries []BatchPutMessageErrorEntry `type:"list"`
}

// String returns the string representation
func (s BatchPutMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchPutMessageOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchPutMessageErrorEntries != nil {
		v := s.BatchPutMessageErrorEntries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "BatchPutMessageErrorEntries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opBatchPutMessage = "BatchPutMessage"

// BatchPutMessageRequest returns a request value for making API operation for
// AWS IoT Events Data.
//
// Sends a set of messages to the AWS IoT Events system. Each message payload
// is transformed into the input you specify ("inputName") and ingested into
// any detectors that monitor that input. If multiple messages are sent, the
// order in which the messages are processed isn't guaranteed. To guarantee
// ordering, you must send messages one at a time and wait for a successful
// response.
//
//    // Example sending a request using BatchPutMessageRequest.
//    req := client.BatchPutMessageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage
func (c *Client) BatchPutMessageRequest(input *BatchPutMessageInput) BatchPutMessageRequest {
	op := &aws.Operation{
		Name:       opBatchPutMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/inputs/messages",
	}

	if input == nil {
		input = &BatchPutMessageInput{}
	}

	req := c.newRequest(op, input, &BatchPutMessageOutput{})

	return BatchPutMessageRequest{Request: req, Input: input, Copy: c.BatchPutMessageRequest}
}

// BatchPutMessageRequest is the request type for the
// BatchPutMessage API operation.
type BatchPutMessageRequest struct {
	*aws.Request
	Input *BatchPutMessageInput
	Copy  func(*BatchPutMessageInput) BatchPutMessageRequest
}

// Send marshals and sends the BatchPutMessage API request.
func (r BatchPutMessageRequest) Send(ctx context.Context) (*BatchPutMessageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchPutMessageResponse{
		BatchPutMessageOutput: r.Request.Data.(*BatchPutMessageOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchPutMessageResponse is the response type for the
// BatchPutMessage API operation.
type BatchPutMessageResponse struct {
	*BatchPutMessageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchPutMessage request.
func (r *BatchPutMessageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
