// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotjobsdataplane

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetPendingJobExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing that is executing the job.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPendingJobExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPendingJobExecutionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPendingJobExecutionsInput"}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPendingJobExecutionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetPendingJobExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of JobExecutionSummary objects with status IN_PROGRESS.
	InProgressJobs []JobExecutionSummary `locationName:"inProgressJobs" type:"list"`

	// A list of JobExecutionSummary objects with status QUEUED.
	QueuedJobs []JobExecutionSummary `locationName:"queuedJobs" type:"list"`
}

// String returns the string representation
func (s GetPendingJobExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPendingJobExecutionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InProgressJobs != nil {
		v := s.InProgressJobs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inProgressJobs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.QueuedJobs != nil {
		v := s.QueuedJobs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "queuedJobs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetPendingJobExecutions = "GetPendingJobExecutions"

// GetPendingJobExecutionsRequest returns a request value for making API operation for
// AWS IoT Jobs Data Plane.
//
// Gets the list of all jobs for a thing that are not in a terminal status.
//
//    // Example sending a request using GetPendingJobExecutionsRequest.
//    req := client.GetPendingJobExecutionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/GetPendingJobExecutions
func (c *Client) GetPendingJobExecutionsRequest(input *GetPendingJobExecutionsInput) GetPendingJobExecutionsRequest {
	op := &aws.Operation{
		Name:       opGetPendingJobExecutions,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/jobs",
	}

	if input == nil {
		input = &GetPendingJobExecutionsInput{}
	}

	req := c.newRequest(op, input, &GetPendingJobExecutionsOutput{})

	return GetPendingJobExecutionsRequest{Request: req, Input: input, Copy: c.GetPendingJobExecutionsRequest}
}

// GetPendingJobExecutionsRequest is the request type for the
// GetPendingJobExecutions API operation.
type GetPendingJobExecutionsRequest struct {
	*aws.Request
	Input *GetPendingJobExecutionsInput
	Copy  func(*GetPendingJobExecutionsInput) GetPendingJobExecutionsRequest
}

// Send marshals and sends the GetPendingJobExecutions API request.
func (r GetPendingJobExecutionsRequest) Send(ctx context.Context) (*GetPendingJobExecutionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPendingJobExecutionsResponse{
		GetPendingJobExecutionsOutput: r.Request.Data.(*GetPendingJobExecutionsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPendingJobExecutionsResponse is the response type for the
// GetPendingJobExecutions API operation.
type GetPendingJobExecutionsResponse struct {
	*GetPendingJobExecutionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPendingJobExecutions request.
func (r *GetPendingJobExecutionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
