// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsecuretunneling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CloseTunnelInput struct {
	_ struct{} `type:"structure"`

	// When set to true, AWS IoT Secure Tunneling deletes the tunnel data immediately.
	Delete *bool `locationName:"delete" type:"boolean"`

	// The ID of the tunnel to close.
	//
	// TunnelId is a required field
	TunnelId *string `locationName:"tunnelId" type:"string" required:"true"`
}

// String returns the string representation
func (s CloseTunnelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloseTunnelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloseTunnelInput"}

	if s.TunnelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TunnelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CloseTunnelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CloseTunnelOutput) String() string {
	return awsutil.Prettify(s)
}

const opCloseTunnel = "CloseTunnel"

// CloseTunnelRequest returns a request value for making API operation for
// AWS IoT Secure Tunneling.
//
// Closes a tunnel identified by the unique tunnel id. When a CloseTunnel request
// is received, we close the WebSocket connections between the client and proxy
// server so no data can be transmitted.
//
//    // Example sending a request using CloseTunnelRequest.
//    req := client.CloseTunnelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/CloseTunnel
func (c *Client) CloseTunnelRequest(input *CloseTunnelInput) CloseTunnelRequest {
	op := &aws.Operation{
		Name:       opCloseTunnel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloseTunnelInput{}
	}

	req := c.newRequest(op, input, &CloseTunnelOutput{})

	return CloseTunnelRequest{Request: req, Input: input, Copy: c.CloseTunnelRequest}
}

// CloseTunnelRequest is the request type for the
// CloseTunnel API operation.
type CloseTunnelRequest struct {
	*aws.Request
	Input *CloseTunnelInput
	Copy  func(*CloseTunnelInput) CloseTunnelRequest
}

// Send marshals and sends the CloseTunnel API request.
func (r CloseTunnelRequest) Send(ctx context.Context) (*CloseTunnelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CloseTunnelResponse{
		CloseTunnelOutput: r.Request.Data.(*CloseTunnelOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CloseTunnelResponse is the response type for the
// CloseTunnel API operation.
type CloseTunnelResponse struct {
	*CloseTunnelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CloseTunnel request.
func (r *CloseTunnelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
